/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.utils;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextStyle;

public final class TextUtils {
    public static Text replace(Text text, String argument, Text replacement) {
        Text t = text.getChildren().isEmpty() ? text : text.toBuilder().removeAll().append((Collection)text.getChildren().stream().map(x -> TextUtils.replace(x, argument, replacement)).collect(Collectors.toList())).build();
        String plain = t.toPlainSingle();
        if (!plain.contains(argument)) {
            return t;
        }
        if (plain.equals(argument)) {
            return replacement;
        }
        Text.Builder builder = Text.builder();
        List<String> strs = Arrays.asList(plain.split(Pattern.quote(argument)));
        for (String str : Iterables.limit(strs, (int)(strs.size() - 1))) {
            builder.append(new Text[]{Text.of((String)str)});
            builder.append(new Text[]{replacement});
        }
        builder.append(new Text[]{Text.of((String)strs.get(strs.size() - 1))});
        if (plain.endsWith(argument)) {
            builder.append(new Text[]{replacement});
        }
        builder.style(new TextStyle[]{text.getStyle()}).color(text.getColor()).append((Collection)text.getChildren());
        return builder.build();
    }
}

