/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.utils;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextTemplate;

public class UserElement
extends CommandElement {
    private static final TextTemplate exception = TextTemplate.of((Object[])new Object[]{"Input value ", TextTemplate.arg((String)"player"), " was not a player."});

    public UserElement(Text key) {
        super(key);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    private static ArgumentParseException exception(String player, CommandArgs args) {
        return args.createError(exception.apply((Map)ImmutableMap.of((Object)"player", (Object)player)).build());
    }

    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        String player = args.next();
        if (player.isEmpty() || player.length() > 16) {
            throw UserElement.exception(player, args);
        }
        Optional ret = Sponge.getGame().getServer().getPlayer(player);
        if (!ret.isPresent()) {
            ret = ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(player);
        }
        return ret.orElseThrow(() -> UserElement.exception(player, args));
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        return Sponge.getGame().getServer().getOnlinePlayers().stream().map(CommandSource::getName).filter(name -> args.nextIfPresent().map(arg -> UserElement.startsWithIgnoreCase(name, arg)).orElse(true)).collect(Collectors.toList());
    }
}

