/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.teslalibs.argument;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mcsimonflash.sponge.teslalibs.argument.FlagsElement;
import com.mcsimonflash.sponge.teslalibs.argument.SequenceElement;
import com.mcsimonflash.sponge.teslalibs.argument.parser.CatalogTypeParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.ChoicesParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.CommandParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.DateParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.DurationParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.FunctionParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.LocationParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.NumberParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.OptionalParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.OrSourceParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.PlayerParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.PositionParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.PredicateParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.SelectorParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.StringParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.UserParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.ValueParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.WorldParser;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.World;

public class Arguments {
    public static final ImmutableMap<String, Boolean> BOOLEANS = ImmutableMap.builder().put((Object)"true", (Object)Boolean.TRUE).put((Object)"t", (Object)Boolean.TRUE).put((Object)"1", (Object)Boolean.TRUE).put((Object)"false", (Object)Boolean.FALSE).put((Object)"f", (Object)Boolean.FALSE).put((Object)"0", (Object)Boolean.FALSE).build();
    public static final ImmutableMap<String, Tristate> TRISTATES = ImmutableMap.builder().put((Object)"true", (Object)Tristate.TRUE).put((Object)"t", (Object)Tristate.TRUE).put((Object)"1", (Object)Tristate.TRUE).put((Object)"false", (Object)Tristate.FALSE).put((Object)"f", (Object)Tristate.FALSE).put((Object)"0", (Object)Tristate.FALSE).put((Object)"undefined", (Object)Tristate.UNDEFINED).put((Object)"u", (Object)Tristate.UNDEFINED).put((Object)"1/2", (Object)Tristate.UNDEFINED).build();
    private static final StringParser STRING = Arguments.string(false, (ImmutableMap<String, String>)ImmutableMap.of());
    private static final StringParser REMAINING_STRINGS = Arguments.string(true, (ImmutableMap<String, String>)ImmutableMap.of());
    private static final NumberParser<Integer> INTEGER = Arguments.number(Integer::decode, (ImmutableMap<String, String>)ImmutableMap.of((Object)"invalid-format", (Object)"Expected <arg> to be an integer."));
    private static final NumberParser<Long> LONG = Arguments.number(Long::decode, (ImmutableMap<String, String>)ImmutableMap.of((Object)"invalid-format", (Object)"Expected <arg> to be a long (integer)."));
    private static final NumberParser<Float> FLOAT = Arguments.number(Float::valueOf, (ImmutableMap<String, String>)ImmutableMap.of((Object)"invalid-format", (Object)"Expected <arg> to be a float (decimal)."));
    private static final NumberParser<Double> DOUBLE = Arguments.number(Double::valueOf, (ImmutableMap<String, String>)ImmutableMap.of((Object)"invalid-format", (Object)"Expected <arg> to be a double (decimal)."));
    private static final ChoicesParser<Boolean> BOOLEAN = Arguments.choices(BOOLEANS, (ImmutableMap<String, String>)ImmutableMap.of((Object)"no-choice", (Object)"Expected <key> to be a boolean (true/false)."));
    private static final ChoicesParser<Tristate> TRISTATE = Arguments.choices(TRISTATES, (ImmutableMap<String, String>)ImmutableMap.of((Object)"no-choice", (Object)"Expected <key> to be a tristate (true/false/undefined)."));
    private static final PlayerParser PLAYER = Arguments.player((ImmutableMap<String, String>)ImmutableMap.of());
    private static final SelectorParser<Player> PLAYER_SELECTOR = PLAYER.selector();
    private static final UserParser USER = Arguments.user((ImmutableMap<String, String>)ImmutableMap.of());
    private static final SelectorParser<User> USER_SELECTOR = USER.selector();
    private static final WorldParser WORLD = Arguments.world((ImmutableMap<String, String>)ImmutableMap.of());
    private static final PositionParser POSITION = Arguments.position((ImmutableMap<String, String>)ImmutableMap.of());
    private static final LocationParser LOCATION = Arguments.location(WORLD.orSource(), POSITION, (ImmutableMap<String, String>)ImmutableMap.of());
    private static final CommandParser COMMAND = Arguments.command((ImmutableMap<String, String>)ImmutableMap.of());
    private static final DateParser DATE = Arguments.date((ImmutableMap<String, String>)ImmutableMap.of());
    private static final DurationParser DURATION = Arguments.duration((ImmutableMap<String, String>)ImmutableMap.of());

    public static ValueParser<String> string() {
        return STRING;
    }

    public static ValueParser<String> remainingStrings() {
        return REMAINING_STRINGS;
    }

    public static NumberParser<Integer> intObj() {
        return INTEGER;
    }

    public static NumberParser<Long> longObj() {
        return LONG;
    }

    public static NumberParser<Double> doubleObj() {
        return DOUBLE;
    }

    public static NumberParser<Float> floatObj() {
        return FLOAT;
    }

    public static ChoicesParser<Boolean> booleanObj() {
        return BOOLEAN;
    }

    public static ChoicesParser<Tristate> tristate() {
        return TRISTATE;
    }

    public static PlayerParser player() {
        return PLAYER;
    }

    public static SelectorParser<Player> playerSelector() {
        return PLAYER_SELECTOR;
    }

    public static UserParser user() {
        return USER;
    }

    public static SelectorParser<User> userSelector() {
        return USER_SELECTOR;
    }

    public static WorldParser world() {
        return WORLD;
    }

    public static PositionParser position() {
        return POSITION;
    }

    public static LocationParser location() {
        return LOCATION;
    }

    public static CommandParser command() {
        return COMMAND;
    }

    public static DateParser date() {
        return DATE;
    }

    public static DurationParser duration() {
        return DURATION;
    }

    public static StringParser string(boolean remaining, ImmutableMap<String, String> unused) {
        return new StringParser(remaining, unused);
    }

    public static <T extends Number> NumberParser<T> number(Function<String, T> function, ImmutableMap<String, String> messages) {
        return new NumberParser<T>(function, messages);
    }

    public static <T> ChoicesParser<T> choices(Map<String, T> choices, ImmutableMap<String, String> messages) {
        return new ChoicesParser<T>(choices, messages);
    }

    public static PlayerParser player(ImmutableMap<String, String> messages) {
        return new PlayerParser(messages);
    }

    public static UserParser user(ImmutableMap<String, String> messages) {
        return new UserParser(messages);
    }

    public static <T> OrSourceParser<T> orSource(Function<CommandSource, T> function, ValueParser<T> delegate, ImmutableMap<String, String> messages) {
        return new OrSourceParser<T>(function, delegate, messages);
    }

    public static WorldParser world(ImmutableMap<String, String> messages) {
        return new WorldParser(messages);
    }

    public static PositionParser position(ImmutableMap<String, String> messages) {
        return new PositionParser(messages);
    }

    public static LocationParser location(ValueParser<World> world, ValueParser<Vector3d> position, ImmutableMap<String, String> unused) {
        return new LocationParser(world, position, unused);
    }

    public static CommandParser command(ImmutableMap<String, String> messages) {
        return new CommandParser(messages);
    }

    public static DateParser date(ImmutableMap<String, String> messages) {
        return new DateParser(messages);
    }

    public static DurationParser duration(ImmutableMap<String, String> messages) {
        return new DurationParser(messages);
    }

    public static <T extends CatalogType> CatalogTypeParser<T> catalogType(Class<T> type, ImmutableMap<String, String> messages) {
        return new CatalogTypeParser<T>(type, messages);
    }

    public static <T> PredicateParser<T> predicate(Predicate<T> predicate, ValueParser<T> delegate, ImmutableMap<String, String> messages) {
        return new PredicateParser<T>(predicate, delegate, messages);
    }

    public static <T, R> FunctionParser<T, R> function(Function<T, R> function, ValueParser<T> delegate, ImmutableMap<String, String> messages) {
        return new FunctionParser<T, R>(function, delegate, messages);
    }

    public static <T> OptionalParser<T> optional(ValueParser<T> delegate, ImmutableMap<String, String> unused) {
        return new OptionalParser<T>(delegate, unused);
    }

    public static <T> SelectorParser<T> selector(Function<Stream<Entity>, Stream<T>> function, ValueParser<T> delegate, ImmutableMap<String, String> messages) {
        return new SelectorParser<T>(function, delegate, messages);
    }

    public static SequenceElement sequence(CommandElement ... elements) {
        return new SequenceElement((ImmutableList<CommandElement>)ImmutableList.copyOf((Object[])elements));
    }

    public static FlagsElement.Builder flags() {
        return new FlagsElement.Builder();
    }
}

