/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.teslalibs.argument.parser;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import com.mcsimonflash.sponge.teslalibs.argument.Arguments;
import com.mcsimonflash.sponge.teslalibs.argument.parser.PredicateParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.StandardParser;
import java.util.function.Function;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;

public class NumberParser<T extends Number>
extends StandardParser<T> {
    private final Function<String, T> function;

    public NumberParser(Function<String, T> function, ImmutableMap<String, String> messages) {
        super(messages);
        this.function = function;
    }

    @Override
    public T parseValue(CommandSource src, CommandArgs args) throws ArgumentParseException {
        String arg = args.next();
        try {
            return (T)((Number)this.function.apply(arg));
        }
        catch (NumberFormatException e) {
            throw args.createError(this.getMessage("invalid-number", "Unable to parse <arg> into a number.", "arg", arg));
        }
        catch (Exception e) {
            throw args.createError(this.getMessage("exception", "Error parsing input <arg>: <exception>", "arg", arg, "exception", e.getMessage()));
        }
    }

    public PredicateParser<T> inRange(Range<T> range) {
        return Arguments.predicate(range, this, (ImmutableMap<String, String>)ImmutableMap.of((Object)"invalid-value", (Object)("Value <value> must be within range " + range + ".")));
    }
}

