/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.teslalibs.argument.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mcsimonflash.sponge.teslalibs.argument.Arguments;
import com.mcsimonflash.sponge.teslalibs.argument.parser.OrSourceParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.SelectorParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.StandardParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.ValueParser;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.util.Identifiable;

public class PlayerParser
extends StandardParser<Player> {
    public PlayerParser(ImmutableMap<String, String> messages) {
        super(messages);
    }

    @Override
    public Player parseValue(CommandSource src, CommandArgs args) throws ArgumentParseException {
        String arg = args.next();
        return (Player)Sponge.getServer().getPlayer(arg).orElseThrow(() -> args.createError(this.getMessage("no-player", "No player found with name <arg>.", "arg", arg)));
    }

    @Override
    public ImmutableList<String> complete(CommandSource src, CommandArgs args, CommandContext ctx) {
        return PlayerParser.complete(args, Sponge.getServer().getOnlinePlayers().stream().map(User::getName));
    }

    public OrSourceParser<Player> orSource() {
        return Arguments.orSource(Player.class::cast, this, (ImmutableMap<String, String>)ImmutableMap.of((Object)"exception", (Object)"Unable to parse player and source is not a Player."));
    }

    public SelectorParser<Player> selector() {
        return Arguments.selector(s -> s.filter(Player.class::isInstance).map(Player.class::cast), this, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    public ValueParser<UUID> toUuid() {
        return this.map(Identifiable::getUniqueId);
    }
}

