/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.teslalibs.argument.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mcsimonflash.sponge.teslalibs.argument.Arguments;
import com.mcsimonflash.sponge.teslalibs.argument.CommandElement;
import com.mcsimonflash.sponge.teslalibs.argument.parser.FunctionParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.OptionalParser;
import com.mcsimonflash.sponge.teslalibs.argument.parser.PredicateParser;
import java.util.function.Function;
import java.util.function.Predicate;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.text.Text;

@FunctionalInterface
public interface ValueParser<T> {
    public T parseValue(CommandSource var1, CommandArgs var2) throws ArgumentParseException;

    default public void parse(Text key, CommandSource src, CommandArgs args, CommandContext ctx) throws ArgumentParseException {
        T value = this.parseValue(src, args);
        if (value instanceof Iterable) {
            ((Iterable)value).forEach(v -> ctx.putArg(key, v));
        } else {
            ctx.putArg(key, value);
        }
    }

    default public ImmutableList<String> complete(CommandSource src, CommandArgs args, CommandContext ctx) {
        return ImmutableList.of();
    }

    default public boolean isOptional() {
        return false;
    }

    default public <R> FunctionParser<T, R> map(Function<T, R> mapper) {
        return Arguments.function(mapper, this, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    default public PredicateParser<T> filter(Predicate<T> predicate) {
        return Arguments.predicate(predicate, this, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    default public OptionalParser<T> optional() {
        return Arguments.optional(this, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    default public CommandElement<T> toElement(String key) {
        return new CommandElement((Text)Text.of((String)key), this);
    }
}

