/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.teslalibs.inventory;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mcsimonflash.sponge.teslalibs.animation.Animatable;
import com.mcsimonflash.sponge.teslalibs.inventory.Action;
import com.mcsimonflash.sponge.teslalibs.inventory.Displayable;
import com.mcsimonflash.sponge.teslalibs.inventory.Element;
import com.mcsimonflash.sponge.teslalibs.inventory.Layout;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;

public class View
implements Animatable<Layout>,
Displayable {
    private final Inventory inventory;
    private final Map<Integer, Element> slots = Maps.newHashMap();
    private final Consumer<Action<InteractInventoryEvent.Open>> onOpen;
    private final Consumer<Action<InteractInventoryEvent.Close>> onClose;
    private final PluginContainer container;

    private View(Builder builder, PluginContainer container) {
        Inventory.Builder b = Inventory.builder();
        builder.properties.forEach(arg_0 -> ((Inventory.Builder)b).property(arg_0));
        this.inventory = b.of(builder.archetype).listener(ClickInventoryEvent.class, this::processClick).listener(InteractInventoryEvent.Open.class, this::processOpen).listener(InteractInventoryEvent.Close.class, this::processClose).build((Object)container);
        this.onOpen = builder.onOpen;
        this.onClose = builder.onClose;
        this.container = container;
    }

    public static View of(InventoryArchetype archetype, PluginContainer container) {
        return View.builder().archetype(archetype).build(container);
    }

    @Override
    public void open(Player player) {
        Task.builder().execute(t -> player.openInventory(this.inventory)).submit((Object)this.container);
    }

    public View define(Layout layout) {
        this.slots.clear();
        for (int i = 0; i < this.inventory.capacity(); ++i) {
            this.setElement(i, layout.getElement(i));
        }
        return this;
    }

    public View update(Layout layout) {
        layout.getElements().forEach(this::setElement);
        return this;
    }

    public void setElement(int index, Element element) {
        this.inventory.query(new QueryOperation[]{QueryOperationTypes.INVENTORY_PROPERTY.of((Object)SlotIndex.of((Object)index))}).first().set(element.getItem().createStack());
        this.slots.put(index, element);
    }

    public int getCapacity() {
        return this.inventory.capacity();
    }

    private void processClick(ClickInventoryEvent event) {
        List slots = event.getTransactions().stream().map(SlotTransaction::getSlot).filter(s -> s.getInventoryProperty(SlotIndex.class).filter(i -> (Integer)i.getValue() < this.inventory.capacity()).isPresent()).collect(Collectors.toList());
        if (!slots.isEmpty()) {
            event.setCancelled(true);
            event.getCause().first(Player.class).ifPresent(p -> slots.forEach(s -> s.getInventoryProperty(SlotIndex.class).map(i -> this.slots.get(i.getValue())).ifPresent(e -> e.process(new Action.Click<ClickInventoryEvent>(event, (Player)p, (Element)e, (Slot)s)))));
        }
    }

    private void processOpen(InteractInventoryEvent.Open event) {
        if (this.onOpen != null) {
            event.getCause().first(Player.class).ifPresent(p -> this.onOpen.accept(new Action<InteractInventoryEvent.Open>(event, (Player)p)));
        }
    }

    private void processClose(InteractInventoryEvent.Close event) {
        if (this.onClose != null) {
            event.getCause().first(Player.class).ifPresent(p -> this.onClose.accept(new Action<InteractInventoryEvent.Close>(event, (Player)p)));
        }
    }

    @Override
    @Deprecated
    public void nextFrame(Layout frame) {
        this.update(frame);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements Displayable.Builder {
        private InventoryArchetype archetype = InventoryArchetypes.DOUBLE_CHEST;
        private List<InventoryProperty> properties = Lists.newArrayList();
        private Consumer<Action<InteractInventoryEvent.Open>> onOpen;
        private Consumer<Action<InteractInventoryEvent.Close>> onClose;

        @Override
        public Builder archetype(InventoryArchetype archetype) {
            this.archetype = archetype;
            return this;
        }

        @Override
        public Builder property(InventoryProperty property) {
            this.properties.add(property);
            return this;
        }

        @Override
        public Builder onOpen(Consumer<Action<InteractInventoryEvent.Open>> action) {
            this.onOpen = action;
            return this;
        }

        @Override
        public Builder onClose(Consumer<Action<InteractInventoryEvent.Close>> action) {
            this.onClose = action;
            return this;
        }

        @Override
        public View build(PluginContainer container) {
            return new View(this, container);
        }
    }
}

