/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import java.util.Iterator;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.stat.internal.StatsHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.jboss.logging.Logger;

public final class TwoPhaseLoad {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, TwoPhaseLoad.class.getName());

    private TwoPhaseLoad() {
    }

    public static void postHydrate(EntityPersister persister, Serializable id, Object[] values, Object rowId, Object object, LockMode lockMode, SharedSessionContractImplementor session) {
        Object version = Versioning.getVersion(values, persister);
        session.getPersistenceContext().addEntry(object, Status.LOADING, values, rowId, id, version, lockMode, true, persister, false);
        if (version != null && LOG.isTraceEnabled()) {
            String versionStr = persister.isVersioned() ? persister.getVersionType().toLoggableString(version, session.getFactory()) : "null";
            LOG.tracef("Version: %s", (Object)versionStr);
        }
    }

    public static void initializeEntity(Object entity, boolean readOnly, SharedSessionContractImplementor session, PreLoadEvent preLoadEvent) {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        EntityEntry entityEntry = persistenceContext.getEntry(entity);
        if (entityEntry == null) {
            throw new AssertionFailure("possible non-threadsafe access to the session");
        }
        TwoPhaseLoad.doInitializeEntity(entity, entityEntry, readOnly, session, preLoadEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doInitializeEntity(Object entity, EntityEntry entityEntry, boolean readOnly, SharedSessionContractImplementor session, PreLoadEvent preLoadEvent) throws HibernateException {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        EntityPersister persister = entityEntry.getPersister();
        Serializable id = entityEntry.getId();
        Object[] hydratedState = entityEntry.getLoadedState();
        boolean debugEnabled = LOG.isDebugEnabled();
        if (debugEnabled) {
            LOG.debugf("Resolving associations for %s", (Object)MessageHelper.infoString(persister, id, session.getFactory()));
        }
        String entityName = persister.getEntityName();
        String[] propertyNames = persister.getPropertyNames();
        Type[] types = persister.getPropertyTypes();
        for (int i = 0; i < hydratedState.length; ++i) {
            Iterator<PreLoadEventListener> value = hydratedState[i];
            Boolean overridingEager = TwoPhaseLoad.getOverridingEager(session, entityName, propertyNames[i], types[i]);
            if (value == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                if (!types[i].isCollectionType()) continue;
                types[i].resolve(value, session, entity, overridingEager);
                continue;
            }
            if (value == PropertyAccessStrategyBackRefImpl.UNKNOWN) continue;
            hydratedState[i] = types[i].resolve(value, session, entity, overridingEager);
        }
        if (session.isEventSource()) {
            preLoadEvent.setEntity(entity).setState(hydratedState).setId(id).setPersister(persister);
            EventListenerGroup<PreLoadEventListener> listenerGroup = session.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.PRE_LOAD);
            for (PreLoadEventListener listener : listenerGroup.listeners()) {
                listener.onPreLoad(preLoadEvent);
            }
        }
        persister.setPropertyValues(entity, hydratedState);
        SessionFactoryImplementor factory = session.getFactory();
        if (persister.canWriteToCache() && session.getCacheMode().isPutEnabled()) {
            if (debugEnabled) {
                LOG.debugf("Adding entity to second-level cache: %s", (Object)MessageHelper.infoString(persister, id, session.getFactory()));
            }
            Object version = Versioning.getVersion(hydratedState, persister);
            CacheEntry entry = persister.buildCacheEntry(entity, hydratedState, version, session);
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            Object cacheKey = cache.generateCacheKey(id, persister, factory, session.getTenantIdentifier());
            if (session.getPersistenceContext().wasInsertedDuringTransaction(persister, id)) {
                cache.update(session, cacheKey, persister.getCacheEntryStructure().structure(entry), version, version);
            } else {
                SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
                try {
                    eventListenerManager.cachePutStart();
                    boolean put = cache.putFromLoad(session, cacheKey, persister.getCacheEntryStructure().structure(entry), version, TwoPhaseLoad.useMinimalPuts(session, entityEntry));
                    if (put && factory.getStatistics().isStatisticsEnabled()) {
                        factory.getStatistics().entityCachePut(StatsHelper.INSTANCE.getRootEntityRole(persister), cache.getRegion().getName());
                    }
                }
                finally {
                    eventListenerManager.cachePutEnd();
                }
            }
        }
        if (persister.hasNaturalIdentifier()) {
            persistenceContext.getNaturalIdHelper().cacheNaturalIdCrossReferenceFromLoad(persister, id, persistenceContext.getNaturalIdHelper().extractNaturalIdValues(hydratedState, persister));
        }
        boolean isReallyReadOnly = readOnly;
        if (!persister.isMutable()) {
            isReallyReadOnly = true;
        } else {
            Object proxy = persistenceContext.getProxy(entityEntry.getEntityKey());
            if (proxy != null) {
                isReallyReadOnly = ((HibernateProxy)proxy).getHibernateLazyInitializer().isReadOnly();
            }
        }
        if (isReallyReadOnly) {
            persistenceContext.setEntryStatus(entityEntry, Status.READ_ONLY);
        } else {
            TypeHelper.deepCopy(hydratedState, persister.getPropertyTypes(), persister.getPropertyUpdateability(), hydratedState, session);
            persistenceContext.setEntryStatus(entityEntry, Status.MANAGED);
        }
        persister.afterInitialize(entity, session);
        if (debugEnabled) {
            LOG.debugf("Done materializing entity %s", (Object)MessageHelper.infoString(persister, id, session.getFactory()));
        }
        if (factory.getStatistics().isStatisticsEnabled()) {
            factory.getStatistics().loadEntity(persister.getEntityName());
        }
    }

    private static Boolean getOverridingEager(SharedSessionContractImplementor session, String entityName, String associationName, Type type) {
        if (type.isAssociationType() || type.isCollectionType()) {
            Boolean overridingEager = TwoPhaseLoad.isEagerFetchProfile(session, entityName + "." + associationName);
            if (LOG.isDebugEnabled() && overridingEager != null) {
                LOG.debugf("Overriding eager fetching using active fetch profile. EntityName: %s, associationName: %s, eager fetching: %s", (Object)entityName, (Object)associationName, (Object)overridingEager);
            }
            return overridingEager;
        }
        return null;
    }

    private static Boolean isEagerFetchProfile(SharedSessionContractImplementor session, String role) {
        LoadQueryInfluencers loadQueryInfluencers = session.getLoadQueryInfluencers();
        for (String fetchProfileName : loadQueryInfluencers.getEnabledFetchProfileNames()) {
            FetchProfile fp = session.getFactory().getFetchProfile(fetchProfileName);
            Fetch fetch = fp.getFetchByRole(role);
            if (fetch == null || Fetch.Style.JOIN != fetch.getStyle()) continue;
            return true;
        }
        return null;
    }

    public static void postLoad(Object entity, SharedSessionContractImplementor session, PostLoadEvent postLoadEvent) {
        if (session.isEventSource()) {
            PersistenceContext persistenceContext = session.getPersistenceContext();
            EntityEntry entityEntry = persistenceContext.getEntry(entity);
            postLoadEvent.setEntity(entity).setId(entityEntry.getId()).setPersister(entityEntry.getPersister());
            EventListenerGroup<PostLoadEventListener> listenerGroup = session.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.POST_LOAD);
            for (PostLoadEventListener listener : listenerGroup.listeners()) {
                listener.onPostLoad(postLoadEvent);
            }
        }
    }

    private static boolean useMinimalPuts(SharedSessionContractImplementor session, EntityEntry entityEntry) {
        if (session.getFactory().getSessionFactoryOptions().isMinimalPutsEnabled()) {
            return session.getCacheMode() != CacheMode.REFRESH;
        }
        return entityEntry.getPersister().hasLazyProperties() && entityEntry.getPersister().isLazyPropertiesCacheable();
    }

    public static void addUninitializedEntity(EntityKey key, Object object, EntityPersister persister, LockMode lockMode, SharedSessionContractImplementor session) {
        session.getPersistenceContext().addEntity(object, Status.LOADING, null, key, null, lockMode, true, persister, false);
    }

    public static void addUninitializedCachedEntity(EntityKey key, Object object, EntityPersister persister, LockMode lockMode, Object version, SharedSessionContractImplementor session) {
        session.getPersistenceContext().addEntity(object, Status.LOADING, null, key, version, lockMode, true, persister, false);
    }
}

