/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.thevoxelbox.voxelsniper.brush.IBrush;
import com.thevoxelbox.voxelsniper.event.RegisterBrushEvent;
import java.util.Map;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Event;

public class Brushes {
    private static final Brushes instance = new Brushes();
    private Map<String, Class<? extends IBrush>> brushes = Maps.newHashMap();
    private int brush_count = 0;

    public static Brushes get() {
        return instance;
    }

    private Brushes() {
    }

    public void registerSniperBrush(Class<? extends IBrush> clazz, String ... handles) {
        Preconditions.checkNotNull(clazz, (Object)"Cannot register null as a brush.");
        RegisterBrushEvent event = new RegisterBrushEvent(Sponge.getCauseStackManager().getCurrentCause(), clazz, handles);
        Sponge.getEventManager().post((Event)event);
        for (String handle : event.getAliases()) {
            this.brushes.put(handle.toLowerCase(), clazz);
        }
        ++this.brush_count;
    }

    public Class<? extends IBrush> getBrushForHandle(String handle) {
        Preconditions.checkNotNull((Object)handle, (Object)"Brushhandle can not be null.");
        return this.brushes.get(handle.toLowerCase());
    }

    public int registeredSniperBrushes() {
        return this.brush_count;
    }

    public int registeredSniperBrushHandles() {
        return this.brushes.size();
    }

    public String getAllBrushes() {
        StringBuilder brushes = new StringBuilder();
        for (String brush : this.brushes.keySet()) {
            brushes.append(", ").append(brush);
        }
        return brushes.toString().substring(2);
    }
}

