/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper;

import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.VoxelSniperConfiguration;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class Message {
    private final SnipeData snipeData;

    public Message(SnipeData snipeData) {
        this.snipeData = snipeData;
    }

    public void brushMessage(String brushMessage) {
        this.snipeData.sendMessage(TextColors.LIGHT_PURPLE, brushMessage);
    }

    public void brushName(String brushName) {
        this.snipeData.sendMessage(TextColors.AQUA, "Brush Type: ", TextColors.LIGHT_PURPLE, brushName);
    }

    public void center() {
        this.snipeData.sendMessage(TextColors.DARK_BLUE, "Brush Center: ", TextColors.DARK_RED, this.snipeData.getcCen());
    }

    public void custom(Text message) {
        this.snipeData.sendMessage(message);
    }

    public void custom(Object ... args) {
        this.snipeData.sendMessage(args);
    }

    public void height() {
        this.snipeData.sendMessage(TextColors.DARK_AQUA, "Brush Height: ", TextColors.DARK_RED, this.snipeData.getVoxelHeight());
    }

    public void performerName(String performerName) {
        this.snipeData.sendMessage(TextColors.DARK_PURPLE, "Performer: ", TextColors.DARK_GREEN, performerName);
    }

    public void replace() {
        this.snipeData.sendMessage(TextColors.AQUA, "Replace Material: ", TextColors.RED, this.snipeData.getReplaceId());
    }

    public void size() {
        this.snipeData.sendMessage(TextColors.GREEN, "Brush Size: ", TextColors.DARK_RED, this.snipeData.getBrushSize());
        if (this.snipeData.getBrushSize() >= (double)VoxelSniperConfiguration.BRUSH_SIZE_WARNING_THRESHOLD) {
            this.snipeData.sendMessage(TextColors.RED, "WARNING: Large brush size selected!");
        }
    }

    public void toggleLightning() {
        this.snipeData.sendMessage(TextColors.GOLD, "Lightning mode has been toggled ", TextColors.DARK_RED, this.snipeData.owner().getSnipeData(this.snipeData.owner().getCurrentToolId()).isLightningEnabled() ? "on" : "off");
    }

    public final void togglePrintout() {
        this.snipeData.sendMessage(TextColors.GOLD, "Brush info printout mode has been toggled ", TextColors.DARK_RED, this.snipeData.owner().getSnipeData(this.snipeData.owner().getCurrentToolId()).isLightningEnabled() ? "on" : "off");
    }

    public void toggleRange() {
        this.snipeData.sendMessage(TextColors.GOLD, "Distance Restriction toggled ", TextColors.DARK_RED, this.snipeData.owner().getSnipeData(this.snipeData.owner().getCurrentToolId()).isRanged() ? "on" : "off", TextColors.GOLD, ". Range is ", TextColors.LIGHT_PURPLE, this.snipeData.owner().getSnipeData(this.snipeData.owner().getCurrentToolId()).getRange());
    }

    public void voxel() {
        this.snipeData.sendMessage(TextColors.GOLD, "Voxel: ", TextColors.RED, this.snipeData.getVoxelId());
    }

    public void voxelList() {
        if (this.snipeData.getVoxelList().isEmpty()) {
            this.snipeData.sendMessage(TextColors.DARK_GREEN, "No blocks selected!");
        } else {
            Text.Builder returnValueBuilder = Text.builder();
            returnValueBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Block Types Selected: "})});
            StringBuilder vl = new StringBuilder();
            for (BlockType blockType : this.snipeData.getVoxelList().getWildcardTypes()) {
                vl.append(blockType.getId());
                vl.append(" ");
            }
            for (BlockState blockState : this.snipeData.getVoxelList().getSpecificTypes()) {
                vl.append(blockState.getId());
                vl.append(" ");
            }
            returnValueBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, vl.toString().trim()})});
            this.snipeData.sendMessage(returnValueBuilder.toText());
        }
    }
}

