/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.Sniper;
import com.thevoxelbox.voxelsniper.VoxelSniperConfiguration;
import com.thevoxelbox.voxelsniper.util.VoxelList;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.World;

public class SnipeData {
    private Sniper owner;
    private Message voxelMessage;
    private double brushSize = VoxelSniperConfiguration.DEFAULT_BRUSH_SIZE;
    private BlockState voxelId = Sponge.getRegistry().getType(BlockState.class, VoxelSniperConfiguration.DEFAULT_VOXEL_ID).orElse(BlockTypes.AIR.getDefaultState());
    private BlockState replaceId = Sponge.getRegistry().getType(BlockState.class, VoxelSniperConfiguration.DEFAULT_REPLACE_ID).orElse(BlockTypes.AIR.getDefaultState());
    private VoxelList voxelList = new VoxelList();
    private Key<?> voxelInkKey = null;
    private Object voxelInkValue = null;
    private Key<?> replaceInkKey = null;
    private Object replaceInkValue = null;
    private int voxelHeight = VoxelSniperConfiguration.DEFAULT_VOXEL_HEIGHT;
    private int cCen = VoxelSniperConfiguration.DEFAULT_CYLINDER_CENTER;
    private int range = 0;
    private boolean ranged = false;
    private boolean lightning = false;

    public SnipeData(Sniper vs) {
        this.owner = vs;
    }

    public double getBrushSize() {
        return this.brushSize;
    }

    public void setBrushSize(double brushSize) {
        this.brushSize = brushSize;
    }

    public int getcCen() {
        return this.cCen;
    }

    public void setcCen(int cCen) {
        this.cCen = cCen;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public String getReplaceId() {
        return this.replaceId.getId();
    }

    public BlockState getReplaceIdState() {
        return this.replaceId;
    }

    public boolean setReplaceId(String replaceId) {
        Optional state = Sponge.getRegistry().getType(BlockState.class, replaceId);
        if (state.isPresent()) {
            this.replaceId = (BlockState)state.get();
            return true;
        }
        return false;
    }

    public void setReplaceId(BlockState state) {
        this.replaceId = state;
    }

    public int getVoxelHeight() {
        return this.voxelHeight;
    }

    public void setVoxelHeight(int voxelHeight) {
        this.voxelHeight = voxelHeight;
    }

    public String getVoxelId() {
        return this.voxelId.getId();
    }

    public BlockState getVoxelIdState() {
        return this.voxelId;
    }

    public boolean setVoxelId(String voxelId) {
        Optional state = Sponge.getRegistry().getType(BlockState.class, voxelId);
        if (state.isPresent()) {
            this.voxelId = (BlockState)state.get();
            return true;
        }
        return false;
    }

    public void setVoxelId(BlockState state) {
        this.voxelId = state;
    }

    public VoxelList getVoxelList() {
        return this.voxelList;
    }

    public void setVoxelList(VoxelList voxelList) {
        this.voxelList = voxelList;
    }

    public Message getVoxelMessage() {
        return this.voxelMessage;
    }

    public void setVoxelMessage(Message voxelMessage) {
        this.voxelMessage = voxelMessage;
    }

    public World getWorld() {
        return this.owner.getPlayer().getWorld();
    }

    public boolean isLightningEnabled() {
        return this.lightning;
    }

    public void setLightningEnabled(boolean lightning) {
        this.lightning = lightning;
    }

    public boolean isRanged() {
        return this.ranged;
    }

    public void setRanged(boolean ranged) {
        this.ranged = ranged;
    }

    public Key<? extends BaseValue<?>> getVoxelInkKey() {
        return this.voxelInkKey;
    }

    public Object getVoxelInkValue() {
        return this.voxelInkValue;
    }

    public <V extends BaseValue<T>, T> void setVoxelInk(Key<V> key, T value) {
        this.voxelInkKey = key;
        this.voxelInkValue = value;
    }

    public Key<? extends BaseValue<?>> getReplaceInkKey() {
        return this.replaceInkKey;
    }

    public Object getReplaceInkValue() {
        return this.replaceInkValue;
    }

    public <V extends BaseValue<T>, T> void setReplaceInk(Key<V> key, T value) {
        this.replaceInkKey = key;
        this.replaceInkValue = value;
    }

    public Sniper owner() {
        return this.owner;
    }

    public void reset() {
        this.voxelId = Sponge.getRegistry().getType(BlockState.class, VoxelSniperConfiguration.DEFAULT_VOXEL_ID).orElse(BlockTypes.AIR.getDefaultState());
        this.replaceId = Sponge.getRegistry().getType(BlockState.class, VoxelSniperConfiguration.DEFAULT_REPLACE_ID).orElse(BlockTypes.AIR.getDefaultState());
        this.brushSize = VoxelSniperConfiguration.DEFAULT_BRUSH_SIZE;
        this.voxelHeight = VoxelSniperConfiguration.DEFAULT_VOXEL_HEIGHT;
        this.cCen = VoxelSniperConfiguration.DEFAULT_CYLINDER_CENTER;
        this.voxelList = new VoxelList();
        this.voxelInkKey = null;
        this.voxelInkValue = null;
        this.replaceInkKey = null;
        this.replaceInkValue = null;
    }

    public void sendMessage(Object ... args) {
        this.owner.getPlayer().sendMessage(Text.of((Object[])args));
    }

    public void sendMessage(Text msg) {
        this.owner.getPlayer().sendMessage(msg);
    }
}

