/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.MutableClassToInstanceMap;
import com.thevoxelbox.voxelsniper.InteractionType;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeAction;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.VoxelSniper;
import com.thevoxelbox.voxelsniper.VoxelSniperConfiguration;
import com.thevoxelbox.voxelsniper.VoxelSniperMessages;
import com.thevoxelbox.voxelsniper.brush.IBrush;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import com.thevoxelbox.voxelsniper.brush.shape.SnipeBrush;
import com.thevoxelbox.voxelsniper.event.sniper.ChangeBrushEvent;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class Sniper {
    private final UUID player;
    private boolean enabled = true;
    private LinkedList<Undo> undoList = new LinkedList();
    private Map<String, SniperTool> tools = Maps.newHashMap();

    public Sniper(Player player) {
        this.player = player.getUniqueId();
        SniperTool sniperTool = new SniperTool(this);
        sniperTool.assignAction(SnipeAction.ARROW, ItemTypes.ARROW);
        sniperTool.assignAction(SnipeAction.GUNPOWDER, ItemTypes.GUNPOWDER);
        this.tools.put(null, sniperTool);
    }

    public String getCurrentToolId() {
        return this.getToolId(this.getPlayer().getItemInHand(HandTypes.MAIN_HAND).isPresent() ? (ItemStack)this.getPlayer().getItemInHand(HandTypes.MAIN_HAND).get() : null);
    }

    public String getToolId(ItemStack itemInHand) {
        if (itemInHand == null) {
            return null;
        }
        for (Map.Entry<String, SniperTool> entry : this.tools.entrySet()) {
            if (!entry.getValue().hasToolAssigned(itemInHand.getType())) continue;
            return entry.getKey();
        }
        return null;
    }

    public SniperTool getSniperTool(ItemStack itemInHand) {
        if (itemInHand == null) {
            return null;
        }
        for (SniperTool entry : this.tools.values()) {
            if (!entry.hasToolAssigned(itemInHand.getType())) continue;
            return entry;
        }
        return null;
    }

    public Player getPlayer() {
        return Sponge.getServer().getPlayer(this.player).orElse(null);
    }

    public boolean snipe(InteractionType action, ItemStack itemInHand) {
        SniperTool sniperTool = this.getSniperTool(itemInHand);
        Player player = this.getPlayer();
        if (sniperTool != null && sniperTool.hasToolAssigned(itemInHand.getType())) {
            if (sniperTool.getCurrentBrush() == null) {
                player.sendMessage(VoxelSniperMessages.NO_BRUSH);
                return true;
            }
            if (!player.hasPermission(sniperTool.getCurrentBrush().getPermissionNode())) {
                player.sendMessage(VoxelSniperMessages.BRUSH_PERMISSION_ERROR.create(sniperTool.getCurrentBrush().getPermissionNode()));
                return true;
            }
            SnipeData snipeData = sniperTool.getSnipeData();
            if (player.get(Keys.IS_SNEAKING).orElse(false).booleanValue()) {
                Location targetBlock = null;
                SnipeAction snipeAction = sniperTool.getActionAssigned(itemInHand.getType());
                Predicate filter = BlockRay.continueAfterFilter((Predicate)BlockRay.onlyAirFilter(), (int)1);
                BlockRay.BlockRayBuilder rayBuilder = BlockRay.from((Entity)player).stopFilter(filter);
                if (snipeData.isRanged()) {
                    rayBuilder.distanceLimit((double)snipeData.getRange());
                }
                BlockRay ray = rayBuilder.build();
                while (ray.hasNext()) {
                    targetBlock = ray.next().getLocation();
                }
                switch (action) {
                    case PRIMARY_MAINHAND: 
                    case PRIMARY_OFFHAND: {
                        switch (snipeAction) {
                            case ARROW: {
                                snipeData.setVoxelId(targetBlock.getBlockType().getDefaultState());
                                snipeData.getVoxelMessage().voxel();
                                return true;
                            }
                            case GUNPOWDER: {
                                snipeData.setVoxelId(targetBlock.getBlock());
                                snipeData.getVoxelMessage().voxel();
                                return true;
                            }
                        }
                        break;
                    }
                    case SECONDARY_MAINHAND: 
                    case SECONDARY_OFFHAND: {
                        switch (snipeAction) {
                            case ARROW: {
                                snipeData.setReplaceId(targetBlock.getBlockType().getDefaultState());
                                snipeData.getVoxelMessage().replace();
                                return true;
                            }
                            case GUNPOWDER: {
                                snipeData.setReplaceId(targetBlock.getBlock());
                                snipeData.getVoxelMessage().replace();
                                return true;
                            }
                        }
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            } else {
                Location targetBlock = null;
                Location lastBlock = null;
                SnipeAction snipeAction = sniperTool.getActionAssigned(itemInHand.getType());
                if (action == InteractionType.PRIMARY_MAINHAND || action == InteractionType.PRIMARY_OFFHAND) {
                    return false;
                }
                Predicate filter = BlockRay.continueAfterFilter((Predicate)BlockRay.onlyAirFilter(), (int)1);
                BlockRay.BlockRayBuilder rayBuilder = BlockRay.from((Entity)player).stopFilter(filter);
                if (snipeData.isRanged()) {
                    rayBuilder.distanceLimit((double)snipeData.getRange());
                }
                BlockRay ray = rayBuilder.build();
                while (ray.hasNext()) {
                    lastBlock = targetBlock;
                    targetBlock = ray.next().getLocation();
                }
                if (targetBlock == null) {
                    player.sendMessage(VoxelSniperMessages.SNIPE_TARGET_NOT_VISIBLE);
                    return false;
                }
                if (lastBlock == null) {
                    lastBlock = targetBlock;
                }
                try {
                    sniperTool.getCurrentBrush().perform(snipeAction, snipeData, (Location<World>)targetBlock, (Location<World>)lastBlock);
                }
                catch (Exception e) {
                    player.sendMessage(VoxelSniperMessages.BRUSH_ERROR);
                    VoxelSniper.getLogger().error("Error performing brush " + sniperTool.getCurrentBrush().getName());
                    e.printStackTrace();
                }
                return true;
            }
        }
        return false;
    }

    public IBrush setBrush(String toolId, Class<? extends IBrush> brush) {
        if (!this.tools.containsKey(toolId)) {
            return null;
        }
        return this.tools.get(toolId).setCurrentBrush(brush);
    }

    public IBrush getBrush(String toolId) {
        if (!this.tools.containsKey(toolId)) {
            return null;
        }
        return this.tools.get(toolId).getCurrentBrush();
    }

    public IBrush previousBrush(String toolId) {
        if (!this.tools.containsKey(toolId)) {
            return null;
        }
        return this.tools.get(toolId).previousBrush();
    }

    public boolean setTool(String toolId, SnipeAction action, ItemType itemInHand) {
        for (Map.Entry<String, SniperTool> entry : this.tools.entrySet()) {
            if (entry.getKey() == toolId || !entry.getValue().hasToolAssigned(itemInHand)) continue;
            return false;
        }
        if (!this.tools.containsKey(toolId)) {
            SniperTool tool = new SniperTool(this);
            this.tools.put(toolId, tool);
        }
        this.tools.get(toolId).assignAction(action, itemInHand);
        return true;
    }

    public void removeTool(String toolId, ItemType itemInHand) {
        if (!this.tools.containsKey(toolId)) {
            SniperTool tool = new SniperTool(this);
            this.tools.put(toolId, tool);
        }
        this.tools.get(toolId).unassignAction(itemInHand);
    }

    public void removeTool(String toolId) {
        if (toolId == null) {
            return;
        }
        this.tools.remove(toolId);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void storeUndo(Undo undo) {
        if (VoxelSniperConfiguration.UNDO_CACHE_SIZE <= 0) {
            return;
        }
        if (undo != null && undo.getSize() > 0) {
            while (this.undoList.size() >= VoxelSniperConfiguration.UNDO_CACHE_SIZE) {
                this.undoList.pollLast();
            }
            this.undoList.push(undo);
        }
    }

    public void undo(int amount) {
        int sum = 0;
        if (this.undoList.isEmpty()) {
            this.getPlayer().sendMessage(VoxelSniperMessages.NOTHING_TO_UNDO);
        } else {
            Undo undo;
            for (int x = 0; x < amount && !this.undoList.isEmpty() && (undo = this.undoList.pop()) != null; ++x) {
                undo.undo();
                sum += undo.getSize();
            }
            this.getPlayer().sendMessage(VoxelSniperMessages.UNDO_SUCCESSFUL.create(sum + ""));
        }
    }

    public void reset(String toolId) {
        SniperTool backup = this.tools.remove(toolId);
        SniperTool newTool = new SniperTool(this);
        for (Map.Entry entry : backup.getActionTools().entrySet()) {
            newTool.assignAction((SnipeAction)((Object)entry.getKey()), (ItemType)entry.getValue());
        }
        this.tools.put(toolId, newTool);
    }

    public SnipeData getSnipeData(String toolId) {
        return this.tools.containsKey(toolId) ? this.tools.get(toolId).getSnipeData() : null;
    }

    public void displayInfo() {
        String currentToolId = this.getCurrentToolId();
        SniperTool sniperTool = this.tools.get(currentToolId);
        IBrush brush = sniperTool.getCurrentBrush();
        this.getPlayer().sendMessage(VoxelSniperMessages.CURRENT_TOOL.create(currentToolId != null ? currentToolId : "Default Tool"));
        if (brush == null) {
            this.getPlayer().sendMessage(VoxelSniperMessages.NO_BRUSH);
            return;
        }
        brush.info(sniperTool.getMessageHelper());
        if (brush instanceof PerformBrush) {
            ((PerformBrush)brush).showInfo(sniperTool.getMessageHelper());
        }
    }

    public SniperTool getSniperTool(String toolId) {
        return this.tools.get(toolId);
    }

    public class SniperTool {
        private BiMap<SnipeAction, ItemType> actionTools = HashBiMap.create();
        private ClassToInstanceMap<IBrush> brushes = MutableClassToInstanceMap.create();
        private Class<? extends IBrush> currentBrush;
        private Class<? extends IBrush> previousBrush;
        private SnipeData snipeData;
        private Message messageHelper;

        SniperTool(Sniper owner) {
            this(SnipeBrush.class, new SnipeData(owner));
        }

        private SniperTool(Class<? extends IBrush> currentBrush, SnipeData snipeData) {
            this.snipeData = snipeData;
            this.messageHelper = new Message(snipeData);
            snipeData.setVoxelMessage(this.messageHelper);
            IBrush newBrushInstance = this.instanciateBrush(currentBrush);
            if (snipeData.owner().getPlayer().hasPermission(newBrushInstance.getPermissionNode())) {
                this.brushes.put(currentBrush, (Object)newBrushInstance);
                this.currentBrush = currentBrush;
            }
        }

        public boolean hasToolAssigned(ItemType material) {
            return this.actionTools.containsValue((Object)material);
        }

        public SnipeAction getActionAssigned(ItemType itemInHand) {
            return (SnipeAction)((Object)this.actionTools.inverse().get((Object)itemInHand));
        }

        public ItemType getToolAssigned(SnipeAction action) {
            return (ItemType)this.actionTools.get((Object)action);
        }

        public void assignAction(SnipeAction action, ItemType itemInHand) {
            this.actionTools.forcePut((Object)action, (Object)itemInHand);
        }

        public void unassignAction(ItemType itemInHand) {
            this.actionTools.inverse().remove((Object)itemInHand);
        }

        public SnipeData getSnipeData() {
            return this.snipeData;
        }

        public Message getMessageHelper() {
            return this.messageHelper;
        }

        public IBrush getCurrentBrush() {
            if (this.currentBrush == null) {
                return null;
            }
            return (IBrush)this.brushes.getInstance(this.currentBrush);
        }

        public IBrush setCurrentBrush(Class<? extends IBrush> brush) {
            Preconditions.checkNotNull(brush, (Object)"Can't set brush to null.");
            IBrush brushInstance = (IBrush)this.brushes.get(brush);
            if (brushInstance == null) {
                brushInstance = this.instanciateBrush(brush);
                Preconditions.checkNotNull((Object)brushInstance, (Object)"Could not instanciate brush class.");
                this.brushes.put(brush, (Object)brushInstance);
            }
            if (this.snipeData.owner().getPlayer().hasPermission(brushInstance.getPermissionNode())) {
                Sponge.getCauseStackManager().pushCause((Object)VoxelSniper.getInstance());
                Sponge.getCauseStackManager().pushCause((Object)this.snipeData.owner().getPlayer());
                ChangeBrushEvent event = new ChangeBrushEvent(Sponge.getCauseStackManager().getCurrentCause(), this.snipeData, brushInstance);
                Sponge.getEventManager().post((Event)event);
                Sponge.getCauseStackManager().popCauses(2);
                this.previousBrush = this.currentBrush;
                this.currentBrush = brush;
                return brushInstance;
            }
            return null;
        }

        public IBrush previousBrush() {
            if (this.previousBrush == null) {
                return null;
            }
            return this.setCurrentBrush(this.previousBrush);
        }

        private IBrush instanciateBrush(Class<? extends IBrush> brush) {
            try {
                return brush.newInstance();
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }

        public BiMap<SnipeAction, ItemType> getActionTools() {
            return this.actionTools;
        }
    }
}

