/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.thevoxelbox.voxelsniper.Sniper;
import com.thevoxelbox.voxelsniper.VoxelSniper;
import com.thevoxelbox.voxelsniper.VoxelSniperConfiguration;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.entity.living.player.Player;

public class SniperManager {
    private static final SniperManager instance = new SniperManager();
    private Cache<UUID, Sniper> sniperInstances = null;

    public static SniperManager get() {
        return instance;
    }

    private SniperManager() {
        Caffeine builder = Caffeine.newBuilder();
        if (VoxelSniperConfiguration.SNIPER_CACHE_EXPIRY > 0) {
            int time = VoxelSniperConfiguration.SNIPER_CACHE_EXPIRY;
            if (VoxelSniperConfiguration.SNIPER_CACHE_EXPIRY < 300) {
                VoxelSniper.getLogger().warn("Sniper cache expiry time is very low, this can cause some thrashing as it checks online players");
                VoxelSniper.getLogger().warn("It is suggested to use a minimal cache expiry time of around 3600 seconds (1 hour)");
                time = 300;
            }
            builder.expireAfterAccess((long)time, TimeUnit.SECONDS);
            Caffeine builder2 = builder.removalListener((uid, sniper, cause) -> {
                if (sniper.getPlayer() != null) {
                    this.sniperInstances.put(uid, sniper);
                }
            });
            this.sniperInstances = builder2.build();
        } else {
            this.sniperInstances = builder.build();
        }
    }

    public Sniper getSniperForPlayer(Player player) {
        Sniper sniper = (Sniper)this.sniperInstances.getIfPresent((Object)player.getUniqueId());
        if (sniper == null) {
            sniper = new Sniper(player);
            this.sniperInstances.put((Object)player.getUniqueId(), (Object)sniper);
        }
        return sniper;
    }
}

