/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class Undo {
    private static final Set<BlockType> FALLING_MATERIALS = Sets.newHashSet((Object[])new BlockType[]{BlockTypes.WATER, BlockTypes.FLOWING_WATER, BlockTypes.LAVA, BlockTypes.FLOWING_LAVA, BlockTypes.SAND, BlockTypes.GRAVEL, BlockTypes.ANVIL});
    private static final Set<BlockType> FALLOFF_MATERIALS = Sets.newHashSet((Object[])new BlockType[]{BlockTypes.SAPLING, BlockTypes.BED, BlockTypes.GOLDEN_RAIL, BlockTypes.DETECTOR_RAIL, BlockTypes.TALLGRASS, BlockTypes.DEADBUSH, BlockTypes.PISTON_EXTENSION, BlockTypes.YELLOW_FLOWER, BlockTypes.RED_FLOWER, BlockTypes.BROWN_MUSHROOM, BlockTypes.RED_MUSHROOM, BlockTypes.TORCH, BlockTypes.FIRE, BlockTypes.WHEAT, BlockTypes.STANDING_SIGN, BlockTypes.WOODEN_DOOR, BlockTypes.LADDER, BlockTypes.RAIL, BlockTypes.WALL_SIGN, BlockTypes.LEVER, BlockTypes.STONE_PRESSURE_PLATE, BlockTypes.IRON_DOOR, BlockTypes.WOODEN_PRESSURE_PLATE, BlockTypes.REDSTONE_TORCH, BlockTypes.UNLIT_REDSTONE_TORCH, BlockTypes.REDSTONE_WIRE, BlockTypes.STONE_BUTTON, BlockTypes.SNOW, BlockTypes.CACTUS, BlockTypes.REEDS, BlockTypes.CAKE, BlockTypes.POWERED_REPEATER, BlockTypes.UNPOWERED_REPEATER, BlockTypes.TRAPDOOR, BlockTypes.PUMPKIN_STEM, BlockTypes.MELON_STEM, BlockTypes.VINE, BlockTypes.WATERLILY, BlockTypes.NETHER_WART, BlockTypes.POWERED_COMPARATOR, BlockTypes.UNPOWERED_COMPARATOR, BlockTypes.DOUBLE_PLANT});
    private final Set<Vector3i> containing = Sets.newHashSet();
    private final List<BlockSnapshot> all;
    private final List<BlockSnapshot> falloff;
    private final List<BlockSnapshot> dropdown;

    public Undo(int suggested_size) {
        this.all = Lists.newArrayListWithExpectedSize((int)suggested_size);
        this.falloff = Lists.newArrayList();
        this.dropdown = Lists.newArrayList();
    }

    public int getSize() {
        return this.all.size() + this.falloff.size() + this.dropdown.size();
    }

    public void put(Location<World> block) {
        Vector3i pos = block.getBlockPosition();
        if (this.containing.contains(pos)) {
            return;
        }
        this.containing.add(pos);
        if (FALLING_MATERIALS.contains(block.getBlockType())) {
            this.dropdown.add(block.createSnapshot());
        } else if (FALLOFF_MATERIALS.contains(block.getBlockType())) {
            this.falloff.add(block.createSnapshot());
        } else {
            this.all.add(block.createSnapshot());
        }
    }

    public void undo() {
        for (BlockSnapshot blockState : this.all) {
            blockState.restore(true, BlockChangeFlags.NEIGHBOR);
        }
        for (BlockSnapshot blockState : this.falloff) {
            blockState.restore(true, BlockChangeFlags.NEIGHBOR);
        }
        for (BlockSnapshot blockState : this.dropdown) {
            blockState.restore(true, BlockChangeFlags.NEIGHBOR);
        }
    }
}

