/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper;

import com.thevoxelbox.voxelsniper.InteractionType;
import com.thevoxelbox.voxelsniper.Sniper;
import com.thevoxelbox.voxelsniper.SniperManager;
import com.thevoxelbox.voxelsniper.VoxelSniperConfiguration;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;

public class VoxelSniperListener {
    @Listener
    public final void onPlayerInteract(InteractItemEvent.Secondary.MainHand event, @Root Player player) {
        if (!player.hasPermission("voxelsniper.sniper")) {
            return;
        }
        Sniper sniper = SniperManager.get().getSniperForPlayer(player);
        if (sniper.isEnabled() && sniper.snipe(InteractionType.SECONDARY_MAINHAND, player.getItemInHand(HandTypes.MAIN_HAND).orElse(null))) {
            event.setCancelled(true);
        }
    }

    @Listener
    public final void onPlayerJoin(ClientConnectionEvent.Join event) {
        Player player = event.getTargetEntity();
        Sniper sniper = SniperManager.get().getSniperForPlayer(player);
        if (VoxelSniperConfiguration.LOGIN_MESSAGE_ENABLED && player.hasPermission("voxelsniper.sniper")) {
            sniper.displayInfo();
        }
    }
}

