/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeAction;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.IBrush;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public abstract class Brush
implements IBrush {
    protected static int WORLD_HEIGHT = (Sponge.getServer().getChunkLayout().getSpaceMax().getY() + 1) * Sponge.getServer().getChunkLayout().getChunkSize().getY();
    protected World world;
    protected Location<World> targetBlock;
    protected Location<World> lastBlock;
    protected Undo undo;
    private String name = "Undefined";

    public static Location<World> clampY(World world, int x, int y, int z) {
        if (y < 0) {
            y = 0;
        } else if (y > WORLD_HEIGHT) {
            y = WORLD_HEIGHT;
        }
        return new Location((Extent)world, x, y, z);
    }

    @Override
    public void perform(SnipeAction action, SnipeData data, Location<World> targetBlock, Location<World> lastBlock) {
        this.world = (World)targetBlock.getExtent();
        this.targetBlock = targetBlock;
        this.lastBlock = lastBlock;
        Sponge.getCauseStackManager().pushCause((Object)data.owner().getPlayer());
        switch (action) {
            case ARROW: {
                this.arrow(data);
                break;
            }
            case GUNPOWDER: {
                this.powder(data);
                break;
            }
        }
        Sponge.getCauseStackManager().popCause();
        this.world = null;
        this.targetBlock = null;
        this.lastBlock = null;
    }

    protected void arrow(SnipeData v) {
    }

    protected void powder(SnipeData v) {
    }

    @Override
    public abstract void info(Message var1);

    @Override
    public void parameters(String[] par, SnipeData v) {
        if (par.length != 0) {
            v.sendMessage(TextColors.RED, "This brush does not accept additional parameters.");
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String name) {
        this.name = name;
    }

    @Override
    public String getBrushCategory() {
        return "General";
    }

    protected void setBlockType(int x, int y, int z, BlockType type) {
        this.setBlockType(x, y, z, type, BlockChangeFlags.ALL);
    }

    protected void setBlockType(int x, int y, int z, BlockType type, BlockChangeFlag flag) {
        if (this.world.getBlockType(x, y, z) == type) {
            return;
        }
        if (this.undo != null) {
            this.undo.put((Location<World>)new Location((Extent)this.world, x, y, z));
        }
        this.world.setBlockType(x, y, z, type, flag);
    }

    protected void setBlockState(int x, int y, int z, BlockState type) {
        this.setBlockState(x, y, z, type, BlockChangeFlags.ALL);
    }

    protected void setBlockState(int x, int y, int z, BlockState type, BlockChangeFlag flag) {
        if (this.world.getBlock(x, y, z) == type) {
            return;
        }
        if (this.undo != null) {
            this.undo.put((Location<World>)new Location((Extent)this.world, x, y, z));
        }
        this.world.setBlock(x, y, z, type, flag);
    }
}

