/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Pattern;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public abstract class PerformBrush
extends Brush {
    private static final Pattern PERFORMER = Pattern.compile("[mMcC][mMcC]?[pP]?");
    protected PerformerType place = PerformerType.TYPE;
    protected PerformerType replace = PerformerType.NONE;
    protected boolean physics = true;

    public void parse(String[] args, SnipeData v) {
        String handle = args[0];
        if (PERFORMER.matcher(handle).matches()) {
            char p = handle.charAt(0);
            if (p == 'm' || p == 'M') {
                this.place = PerformerType.TYPE;
            } else if (p == 'c' || p == 'C') {
                this.place = PerformerType.COMBO;
            }
            int i = 1;
            if (handle.length() >= 2) {
                char r = handle.charAt(i);
                i = 2;
                if (r == 'm' || r == 'M') {
                    this.replace = PerformerType.TYPE;
                } else if (r == 'c' || r == 'C') {
                    this.replace = PerformerType.COMBO;
                } else {
                    i = 1;
                    this.replace = PerformerType.NONE;
                }
            }
            if (handle.length() >= i + 1) {
                char e = handle.charAt(i);
                this.physics = e != 'p' && e != 'P';
            }
            this.parameters(Arrays.copyOfRange(args, 1, args.length), v);
        } else {
            this.parameters(args, v);
        }
    }

    public void showInfo(Message vm) {
        String name = this.place.name().toLowerCase();
        if (this.replace != PerformerType.NONE) {
            name = name + " " + this.replace.name().toLowerCase();
        }
        vm.performerName(name);
        vm.voxel();
        if (this.replace != PerformerType.NONE) {
            vm.replace();
        }
    }

    protected boolean perform(SnipeData v, Location<World> pos) {
        return this.perform(v, pos.getBlockX(), pos.getBlockY(), pos.getBlockZ());
    }

    protected boolean perform(SnipeData v, int x, int y, int z) {
        BlockState current;
        if (y < 0 || y >= Brush.WORLD_HEIGHT) {
            return false;
        }
        if (this.replace != PerformerType.NONE) {
            current = this.world.getBlock(x, y, z);
            switch (this.replace) {
                case TYPE: {
                    if (current.getType() == v.getReplaceIdState().getType()) break;
                    return false;
                }
                case STATE: {
                    break;
                }
                case COMBO: {
                    if (current == v.getReplaceIdState()) break;
                    return false;
                }
            }
        }
        switch (this.place) {
            case TYPE: {
                this.setBlockType(x, y, z, v.getVoxelIdState().getType(), this.physics ? BlockChangeFlags.ALL : BlockChangeFlags.NONE);
                break;
            }
            case STATE: {
                current = this.world.getBlock(x, y, z);
                Optional place = current.with(v.getVoxelInkKey(), v.getVoxelInkValue());
                if (!place.isPresent()) {
                    return false;
                }
                this.setBlockState(x, y, z, (BlockState)place.get(), this.physics ? BlockChangeFlags.ALL : BlockChangeFlags.NONE);
                break;
            }
            case COMBO: {
                this.setBlockState(x, y, z, v.getVoxelIdState(), this.physics ? BlockChangeFlags.ALL : BlockChangeFlags.NONE);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported place type " + this.place.name());
            }
        }
        return true;
    }

    public static enum PerformerType {
        TYPE,
        STATE,
        COMBO,
        NONE;

    }
}

