/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.chunk;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.chunk.ChunkBrush;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Chunk;

public class CanyonBrush
extends ChunkBrush {
    private static final int SHIFT_LEVEL_MIN = -255;
    private static final int SHIFT_LEVEL_MAX = 255;
    protected int yLevel = -10;

    public CanyonBrush() {
        this.setName("Canyon");
    }

    @Override
    protected void createUndo(int chunks) {
        this.undo = new Undo(chunks * 16384);
    }

    @Override
    protected void storeUndo(SnipeData v) {
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected void operate(SnipeData v, Chunk chunk) {
        int minx = chunk.getBlockMin().getX();
        int minz = chunk.getBlockMin().getZ();
        BlockState fillBlock = v.getVoxelIdState();
        if (fillBlock.getType() == BlockTypes.AIR) {
            fillBlock = BlockTypes.STONE.getDefaultState();
        }
        int sy = this.yLevel < 0 ? 0 : WORLD_HEIGHT;
        int ey = this.yLevel < 0 ? WORLD_HEIGHT : 0;
        int dir = this.yLevel < 0 ? 1 : -1;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = sy; y != ey; y += dir) {
                    int srcy = y - this.yLevel;
                    if (srcy < 0) {
                        this.setBlockState(minx + x, y, minz + z, fillBlock);
                        continue;
                    }
                    if (srcy > WORLD_HEIGHT) {
                        this.setBlockType(minx + x, y, minz + z, BlockTypes.AIR);
                        continue;
                    }
                    this.setBlockState(minx + x, y, minz + z, this.world.getBlock(minx + x, srcy, minz + z));
                }
            }
        }
    }

    @Override
    public void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom(TextColors.GREEN + "Shift Level set to " + this.yLevel);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        if (par.length == 0 || par[0].equalsIgnoreCase("info")) {
            v.sendMessage(TextColors.GREEN + "y[number] to set the Level to which the land will be shifted down");
        }
        if (par[0].startsWith("y")) {
            int _i = Integer.parseInt(par[0].replace("y", ""));
            if (_i < -255) {
                _i = -255;
            } else if (_i > 255) {
                _i = 255;
            }
            this.yLevel = _i;
            v.sendMessage(TextColors.GREEN, "Shift Level set to " + this.yLevel);
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.canyon";
    }
}

