/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.chunk;

import com.google.common.collect.Sets;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Chunk;

public class EntityRemovalBrush
extends Brush {
    private static final Set<EntityType> default_exemptions = Sets.newHashSet();
    private Set<EntityType> special_exemptions;

    public EntityRemovalBrush() {
        this.setName("Entity Removal");
    }

    private void radialRemoval(SnipeData v) {
        int cx = this.targetBlock.getChunkPosition().getX();
        int cz = this.targetBlock.getChunkPosition().getZ();
        int entityCount = 0;
        int chunkCount = 0;
        if (v.getBrushSize() < 16.0) {
            Optional chunk = this.world.getChunk(cx, 0, cz);
            if (chunk.isPresent()) {
                entityCount += this.removeEntities((Chunk)chunk.get());
                ++chunkCount;
            }
        } else {
            int radius = (int)Math.ceil(v.getBrushSize() / 16.0);
            int radiusSquared = radius * radius;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    Optional chunk;
                    if (x * x + z * z > radiusSquared || !(chunk = this.world.getChunk(x + cx, 0, z + cz)).isPresent()) continue;
                    entityCount += this.removeEntities((Chunk)chunk.get());
                    ++chunkCount;
                }
            }
        }
        v.sendMessage(TextColors.GREEN, "Removed ", TextColors.RED, entityCount, TextColors.GREEN, " entities out of ", TextColors.BLUE, chunkCount, TextColors.GREEN, chunkCount == 1 ? " chunk." : " chunks.");
    }

    private int removeEntities(Chunk chunk) {
        int entityCount = 0;
        Set<EntityType> exempt = this.special_exemptions;
        if (exempt == null) {
            exempt = default_exemptions;
        }
        for (Entity entity : chunk.getEntities()) {
            EntityType type = entity.getType();
            if (exempt.contains(type)) continue;
            entity.remove();
            ++entityCount;
        }
        return entityCount;
    }

    @Override
    protected void arrow(SnipeData v) {
        this.radialRemoval(v);
    }

    @Override
    protected void powder(SnipeData v) {
        this.radialRemoval(v);
    }

    @Override
    public void info(Message vm) {
        vm.brushName(this.getName());
        Set<EntityType> exempt = this.special_exemptions;
        if (exempt == null) {
            exempt = default_exemptions;
        }
        StringBuilder types = new StringBuilder();
        for (EntityType type : exempt) {
            types.append(", ").append(type.getId());
        }
        vm.custom(TextColors.AQUA, "Exempted entity types:");
        vm.custom(types.toString().substring(2));
        vm.size();
    }

    @Override
    public void parameters(String[] par, SnipeData v) {
        if (par.length != 0 && par[0].equalsIgnoreCase("info")) {
            Set<EntityType> exempt = this.special_exemptions;
            if (exempt == null) {
                exempt = default_exemptions;
            }
            StringBuilder types = new StringBuilder();
            for (EntityType type : exempt) {
                types.append(", ").append(type.getId());
            }
            v.sendMessage(TextColors.AQUA, "Exempted entity types:");
            v.sendMessage(types.toString().substring(2));
            return;
        }
        for (String currentParam : par) {
            if (!currentParam.startsWith("+") && !currentParam.startsWith("-")) continue;
            boolean isAddOperation = currentParam.startsWith("+");
            Optional type = Sponge.getRegistry().getType(EntityType.class, currentParam.substring(1));
            if (!type.isPresent()) continue;
            if (this.special_exemptions == null) {
                this.special_exemptions = Sets.newHashSet(default_exemptions);
            }
            if (isAddOperation) {
                this.special_exemptions.add((EntityType)type.get());
                v.sendMessage(String.format("Added %s to entity exemptions list.", ((EntityType)type.get()).getId()));
                continue;
            }
            this.special_exemptions.remove(type.get());
            v.sendMessage(String.format("Removed %s to entity exemptions list.", ((EntityType)type.get()).getId()));
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.entityremoval";
    }

    static {
        default_exemptions.add(EntityTypes.PLAYER);
        default_exemptions.add(EntityTypes.PAINTING);
        default_exemptions.add(EntityTypes.ITEM_FRAME);
        default_exemptions.add(EntityTypes.ARMOR_STAND);
        default_exemptions.add(EntityTypes.ENDER_CRYSTAL);
    }
}

