/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.chunk;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.chunk.ChunkBrush;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Chunk;

public class FlatOceanBrush
extends ChunkBrush {
    private static final int DEFAULT_WATER_LEVEL = 29;
    private static final int DEFAULT_FLOOR_LEVEL = 8;
    private int waterLevel = 29;
    private int floorLevel = 8;

    public FlatOceanBrush() {
        this.setName("FlatOcean");
    }

    @Override
    protected void createUndo(int chunks) {
        this.undo = new Undo(chunks * 16384);
    }

    @Override
    protected void storeUndo(SnipeData v) {
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected void operate(SnipeData v, Chunk chunk) {
        int minx = chunk.getBlockMin().getX();
        int miny = chunk.getBlockMin().getY();
        int minz = chunk.getBlockMin().getZ();
        int maxx = chunk.getBlockMax().getX();
        int maxy = chunk.getBlockMax().getY();
        int maxz = chunk.getBlockMax().getZ();
        for (int x = minx; x <= maxx; ++x) {
            for (int z = minz; z <= maxz; ++z) {
                for (int y = miny; y <= maxy; ++y) {
                    if (y <= this.floorLevel) {
                        this.setBlockType(x, y, z, BlockTypes.DIRT);
                        continue;
                    }
                    if (y <= this.waterLevel) {
                        this.setBlockType(x, y, z, BlockTypes.WATER, BlockChangeFlags.NONE);
                        continue;
                    }
                    this.setBlockType(x, y, z, BlockTypes.AIR);
                }
            }
        }
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom(TextColors.RED + "THIS BRUSH DOES NOT UNDO");
        vm.custom(TextColors.GREEN + "Water level set to " + this.waterLevel);
        vm.custom(TextColors.GREEN + "Ocean floor level set to " + this.floorLevel);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 0; i < par.length; ++i) {
            String parameter = par[i];
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(TextColors.GREEN + "yo[number] to set the Level to which the water will rise.");
                v.sendMessage(TextColors.GREEN + "yl[number] to set the Level to which the ocean floor will rise.");
            }
            if (parameter.startsWith("yo")) {
                try {
                    int newWaterLevel;
                    this.waterLevel = newWaterLevel = Integer.parseInt(parameter.replace("yo", ""));
                    if (this.waterLevel <= 0) {
                        v.sendMessage(TextColors.RED, "Water level cannot be negative.");
                        continue;
                    }
                    v.sendMessage(TextColors.GREEN + "Water Level set to " + this.waterLevel);
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid water level value.");
                }
                continue;
            }
            if (!parameter.startsWith("yl")) continue;
            try {
                int newFloorLevel;
                this.floorLevel = newFloorLevel = Integer.parseInt(parameter.replace("yl", ""));
                if (this.waterLevel <= 0) {
                    v.sendMessage(TextColors.RED, "Ocean floor level cannot be negative.");
                    continue;
                }
                v.sendMessage(TextColors.GREEN + "Ocean floor Level set to " + this.floorLevel);
                continue;
            }
            catch (NumberFormatException e) {
                v.sendMessage(TextColors.RED, "Invalid ocean floor level value.");
            }
        }
        if (this.floorLevel < 0) {
            this.floorLevel = 0;
        }
        if (this.waterLevel <= this.floorLevel) {
            this.waterLevel = this.floorLevel + 1;
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.flatocean";
    }
}

