/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.chunk;

import com.google.common.collect.Sets;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.chunk.ChunkBrush;
import com.thevoxelbox.voxelsniper.util.BlockHelper;
import java.util.Set;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Chunk;

public class OceanBrush
extends ChunkBrush {
    private static final int WATER_LEVEL_DEFAULT = 62;
    private static final int WATER_LEVEL_MIN = 12;
    private static final int WATER_DEPTH_MIN = 6;
    private static final Set<BlockType> EXCLUDED_MATERIALS = Sets.newHashSet();
    private int waterLevel = 62;
    private boolean coverFloor = false;

    public OceanBrush() {
        this.setName("OCEANATOR 5000(tm)");
    }

    @Override
    protected void createUndo(int chunks) {
        this.undo = new Undo(chunks * 16384);
    }

    @Override
    protected void storeUndo(SnipeData v) {
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    private int getActualHeight(int bx, int bz) {
        for (int y = WORLD_HEIGHT; y > 0; --y) {
            BlockState state = this.world.getBlock(bx, y, bz);
            if (state.getType() != BlockTypes.AIR) continue;
            return y;
        }
        return 0;
    }

    private int getHeight(int bx, int bz, int start) {
        for (int y = start; y > 0; --y) {
            BlockState state = this.world.getBlock(bx, y, bz);
            if (BlockHelper.isLiquidOrGas(state)) continue;
            if (BlockHelper.isSolid(state)) {
                return y;
            }
            if (!EXCLUDED_MATERIALS.contains(state.getType())) continue;
            return y;
        }
        return 0;
    }

    @Override
    protected void operate(SnipeData v, Chunk chunk) {
        int minx = chunk.getBlockMin().getX();
        int minz = chunk.getBlockMin().getZ();
        BlockState fillBlock = v.getVoxelIdState();
        if (fillBlock.getType() == BlockTypes.AIR) {
            fillBlock = BlockTypes.DIRT.getDefaultState();
        }
        for (int x = 0; x < 16; ++x) {
            int x0 = minx + x;
            for (int z = 0; z < 16; ++z) {
                int y;
                int height;
                int z0 = minz + z;
                int actualheight = this.getActualHeight(x0, z0);
                int depth = height = this.getHeight(x0, z0, actualheight);
                if (height > this.waterLevel) {
                    depth = this.waterLevel - (height - this.waterLevel) - 6;
                }
                if (depth > this.waterLevel - 6) {
                    depth = 6;
                }
                if (depth < 12) {
                    depth = 12;
                }
                for (y = actualheight; y > this.waterLevel; --y) {
                    this.setBlockType(x0, y, z0, BlockTypes.AIR);
                }
                while (y > depth) {
                    this.setBlockType(x0, y, z0, BlockTypes.WATER);
                    --y;
                }
                if (!this.coverFloor) continue;
                this.setBlockState(x0, y, z0, v.getVoxelIdState());
            }
        }
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        this.coverFloor = false;
        for (int i = 0; i < par.length; ++i) {
            String parameter = par[i];
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(TextColors.BLUE, "Parameters:");
                v.sendMessage(TextColors.GREEN, "-wlevel #  ", TextColors.BLUE, "--  Sets the water level (e.g. -wlevel 64)");
                v.sendMessage(TextColors.GREEN, "-cfloor    ", TextColors.BLUE, "--  Enables or disables sea floor cover (Cover material will be your voxel material)");
                continue;
            }
            if (parameter.equalsIgnoreCase("-wlevel")) {
                if (i + 1 >= par.length) {
                    v.sendMessage(TextColors.RED, "Missing parameter. Correct syntax: -wlevel [#] (e.g. -wlevel 64)");
                    continue;
                }
                try {
                    int temp = Integer.parseInt(par[++i]);
                    if (temp <= 12) {
                        v.sendMessage(TextColors.RED, "Error: Your specified water level was below 12.");
                        continue;
                    }
                    this.waterLevel = temp;
                    v.sendMessage(TextColors.BLUE, "Water level set to ", TextColors.GREEN, this.waterLevel);
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalud water level.");
                }
                continue;
            }
            if (!parameter.equalsIgnoreCase("-cfloor") && !parameter.equalsIgnoreCase("-coverfloor")) continue;
            this.coverFloor = true;
            v.sendMessage(TextColors.BLUE, "Floor cover ", TextColors.GREEN, "enabled.");
        }
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom(TextColors.BLUE, "Water level set to ", TextColors.GREEN, this.waterLevel);
        vm.custom(TextColors.BLUE, "Floor cover ", TextColors.GREEN, (this.coverFloor ? "enabled" : "disabled") + ".");
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.ocean";
    }

    static {
        EXCLUDED_MATERIALS.add(BlockTypes.LOG);
        EXCLUDED_MATERIALS.add(BlockTypes.LEAVES);
        EXCLUDED_MATERIALS.add(BlockTypes.LOG2);
        EXCLUDED_MATERIALS.add(BlockTypes.LEAVES2);
        EXCLUDED_MATERIALS.add(BlockTypes.BROWN_MUSHROOM_BLOCK);
        EXCLUDED_MATERIALS.add(BlockTypes.RED_MUSHROOM_BLOCK);
        EXCLUDED_MATERIALS.add(BlockTypes.MELON_BLOCK);
        EXCLUDED_MATERIALS.add(BlockTypes.PUMPKIN);
    }
}

