/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.misc;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.BiomeTypes;

public class BiomeBrush
extends Brush {
    private BiomeType selectedBiome = BiomeTypes.PLAINS;

    public BiomeBrush() {
        this.setName("Biome (/b biome [Biome Name])");
    }

    private void biome(SnipeData v, Location<World> targetBlock) {
        double brushSize = v.getBrushSize();
        double brushSizeSquared = brushSize * brushSize;
        int tx = targetBlock.getBlockX();
        int tz = targetBlock.getBlockZ();
        int minx = GenericMath.floor((double)((double)this.targetBlock.getBlockX() - brushSize));
        int maxx = GenericMath.floor((double)((double)this.targetBlock.getBlockX() + brushSize)) + 1;
        int minz = GenericMath.floor((double)((double)this.targetBlock.getBlockZ() - brushSize));
        int maxz = GenericMath.floor((double)((double)this.targetBlock.getBlockZ() + brushSize)) + 1;
        for (int x = minx; x <= maxx; ++x) {
            double xs = (tx - x) * (tx - x);
            for (int z = minz; z <= maxz; ++z) {
                double zs = (tz - z) * (tz - z);
                if (!(xs + zs <= brushSizeSquared)) continue;
                this.world.setBiome(x, 0, z, this.selectedBiome);
            }
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.biome(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.biome(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.custom(TextColors.GOLD, "Currently selected biome type: ", TextColors.DARK_GREEN, this.selectedBiome.getName());
    }

    @Override
    public final void parameters(String[] args, SnipeData v) {
        if (args[0].equalsIgnoreCase("info")) {
            v.sendMessage(TextColors.GOLD + "Biome Brush Parameters:");
            String availableBiomes = "";
            for (BiomeType biome : Sponge.getRegistry().getAllOf(BiomeType.class)) {
                availableBiomes = availableBiomes + ", " + biome.getId();
            }
            availableBiomes = availableBiomes.substring(2);
            v.sendMessage(TextColors.DARK_BLUE, "Available biomes: ", TextColors.DARK_GREEN, availableBiomes);
        } else {
            String biomeName = args[0];
            Optional biome = Sponge.getRegistry().getType(BiomeType.class, biomeName);
            if (!biome.isPresent()) {
                v.sendMessage(TextColors.RED, "Unknown biome type: ", TextColors.DARK_AQUA, biomeName);
            } else {
                this.selectedBiome = (BiomeType)biome.get();
                v.sendMessage(TextColors.GOLD, "Currently selected biome type: ", TextColors.DARK_GREEN, this.selectedBiome.getName());
            }
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.biome";
    }
}

