/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.misc;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class CleanSnowBrush
extends Brush {
    public CleanSnowBrush() {
        this.setName("Clean Snow");
    }

    private void cleanSnow(SnipeData v, Location<World> targetBlock) {
        double brushSize = v.getBrushSize();
        double brushSizeSquared = brushSize * brushSize;
        int tx = targetBlock.getBlockX();
        int ty = targetBlock.getBlockY();
        int tz = targetBlock.getBlockZ();
        int minx = GenericMath.floor((double)((double)targetBlock.getBlockX() - brushSize));
        int maxx = GenericMath.floor((double)((double)targetBlock.getBlockX() + brushSize)) + 1;
        int miny = Math.max(GenericMath.floor((double)((double)targetBlock.getBlockY() - brushSize)), 0);
        int maxy = Math.min(GenericMath.floor((double)((double)targetBlock.getBlockY() + brushSize)) + 1, WORLD_HEIGHT);
        int minz = GenericMath.floor((double)((double)targetBlock.getBlockZ() - brushSize));
        int maxz = GenericMath.floor((double)((double)targetBlock.getBlockZ() + brushSize)) + 1;
        if (miny <= 0) {
            miny = 1;
        }
        this.undo = new Undo(GenericMath.floor((double)(Math.PI * (brushSize + 1.0) * (brushSize + 1.0) * (brushSize + 1.0) / 3.0)));
        for (int x = minx; x <= maxx; ++x) {
            double xs = (tx - x) * (tx - x);
            for (int z = minz; z <= maxz; ++z) {
                double zs = (tz - z) * (tz - z);
                for (int y = maxy; y >= miny; --y) {
                    BlockType below;
                    double ys = (ty - y) * (ty - y);
                    if (!(xs + ys + zs < brushSizeSquared) || this.world.getBlockType(x, y, z) != BlockTypes.SNOW_LAYER || (below = this.world.getBlockType(x, y - 1, z)) != BlockTypes.SNOW_LAYER && below != BlockTypes.AIR) continue;
                    this.setBlockType(x, y, z, BlockTypes.AIR);
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.cleanSnow(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.cleanSnow(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.cleansnow";
    }
}

