/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.misc;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import com.thevoxelbox.voxelsniper.util.BlockHelper;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class DrainBrush
extends Brush {
    public DrainBrush() {
        this.setName("Drain");
    }

    private void drain(SnipeData v, Location<World> targetBlock) {
        double brushSize = v.getBrushSize();
        int minx = GenericMath.floor((double)((double)targetBlock.getBlockX() - brushSize));
        int maxx = GenericMath.floor((double)((double)targetBlock.getBlockX() + brushSize)) + 1;
        int miny = Math.max(GenericMath.floor((double)((double)targetBlock.getBlockY() - brushSize)), 0);
        int maxy = Math.min(GenericMath.floor((double)((double)targetBlock.getBlockY() + brushSize)) + 1, WORLD_HEIGHT);
        int minz = GenericMath.floor((double)((double)targetBlock.getBlockZ() - brushSize));
        int maxz = GenericMath.floor((double)((double)targetBlock.getBlockZ() + brushSize)) + 1;
        this.undo = new Undo(GenericMath.floor((double)(8.0 * (brushSize + 1.0) * (brushSize + 1.0) * (brushSize + 1.0))));
        for (int x = minx; x <= maxx; ++x) {
            for (int z = minz; z <= maxz; ++z) {
                for (int y = maxy; y >= miny; --y) {
                    BlockState block = this.world.getBlock(x, y, z);
                    if (!BlockHelper.isLiquid(block)) continue;
                    this.setBlockType(x, y, z, BlockTypes.AIR);
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.drain(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.drain(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.drain";
    }
}

