/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.misc;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.text.format.TextColors;

public class EntityBrush
extends Brush {
    private EntityType entityType = EntityTypes.ZOMBIE;

    public EntityBrush() {
        this.setName("Entity");
    }

    private void spawn(SnipeData v) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, (Object)SpawnTypes.PLUGIN);
            int x = 0;
            while ((double)x < v.getBrushSize()) {
                Entity e = this.world.createEntity(this.entityType, this.lastBlock.getBlockPosition());
                this.world.spawnEntity(e);
                ++x;
            }
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.spawn(v);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.spawn(v);
    }

    @Override
    public final void info(Message vm) {
        vm.custom(TextColors.LIGHT_PURPLE, "Entity brush (", TextColors.DARK_PURPLE, this.entityType.getName(), TextColors.LIGHT_PURPLE, ")");
        vm.size();
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        if (par.length == 0 || par[0].equalsIgnoreCase("info")) {
            v.sendMessage(TextColors.AQUA, "Available entity types:");
            StringBuilder types = new StringBuilder();
            for (EntityType type : Sponge.getRegistry().getAllOf(EntityType.class)) {
                types.append(", ").append(type.getId().replace("minecraft:", ""));
            }
            v.sendMessage(types.toString().substring(2));
        } else {
            Optional selection = Sponge.getRegistry().getType(EntityType.class, par[0]);
            if (!selection.isPresent()) {
                v.sendMessage(TextColors.RED, "This is not a valid entity!");
            } else {
                this.entityType = (EntityType)selection.get();
                v.sendMessage(TextColors.GREEN, "Entity type set to " + this.entityType.getName());
            }
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.entity";
    }
}

