/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.misc;

import com.flowpowered.math.GenericMath;
import com.flowpowered.noise.NoiseQuality;
import com.flowpowered.noise.module.source.Perlin;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import com.thevoxelbox.voxelsniper.util.BlockHelper;
import java.util.HashSet;
import java.util.Set;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class HeatRayBrush
extends Brush {
    private static final double REQUIRED_OBSIDIAN_DENSITY = 0.6;
    private static final double REQUIRED_COBBLE_DENSITY = 0.45;
    private static final double REQUIRED_FIRE_DENSITY = 0.1;
    private static final Set<BlockType> FLAMABLE_BLOCKS = new HashSet<BlockType>();
    private Perlin perlin = new Perlin();
    private int octaves = 5;
    private double frequency = 1.0;
    private double persistence = 0.5;

    public HeatRayBrush() {
        this.setName("Heat Ray");
        this.perlin.setLacunarity(2.0);
        this.perlin.setNoiseQuality(NoiseQuality.STANDARD);
    }

    public void heatRay(SnipeData v, Location<World> targetBlock) {
        double brushSize = v.getBrushSize();
        double brushSizeSquared = brushSize * brushSize;
        int tx = targetBlock.getBlockX();
        int ty = targetBlock.getBlockY();
        int tz = targetBlock.getBlockZ();
        int minx = GenericMath.floor((double)((double)targetBlock.getBlockX() - brushSize));
        int maxx = GenericMath.floor((double)((double)targetBlock.getBlockX() + brushSize)) + 1;
        int miny = Math.max(GenericMath.floor((double)((double)targetBlock.getBlockY() - brushSize)), 0);
        int maxy = Math.min(GenericMath.floor((double)((double)targetBlock.getBlockY() + brushSize)) + 1, WORLD_HEIGHT);
        int minz = GenericMath.floor((double)((double)targetBlock.getBlockZ() - brushSize));
        int maxz = GenericMath.floor((double)((double)targetBlock.getBlockZ() + brushSize)) + 1;
        this.undo = new Undo(GenericMath.floor((double)(Math.PI * 4 * (brushSize + 1.0) * (brushSize + 1.0) * (brushSize + 1.0) / 3.0)));
        for (int x = minx; x <= maxx; ++x) {
            double xs = (tx - x) * (tx - x);
            for (int y = miny; y <= maxy; ++y) {
                double ys = (ty - y) * (ty - y);
                for (int z = minz; z <= maxz; ++z) {
                    BlockState current;
                    double zs = (tz - z) * (tz - z);
                    if (!(xs + ys + zs < brushSizeSquared) || (current = this.world.getBlock(x, y, z)).getType() == BlockTypes.AIR) continue;
                    if (BlockHelper.isLiquid(current)) {
                        this.setBlockType(x, y, z, BlockTypes.AIR);
                        continue;
                    }
                    if (FLAMABLE_BLOCKS.contains(current.getType())) {
                        this.setBlockType(x, y, z, BlockTypes.FIRE);
                        continue;
                    }
                    double noise = this.perlin.getValue((double)x, (double)y, (double)z);
                    if (noise >= 0.6) {
                        this.setBlockType(x, y, z, BlockTypes.OBSIDIAN);
                        continue;
                    }
                    if (noise >= 0.45) {
                        this.setBlockType(x, y, z, BlockTypes.COBBLESTONE);
                        continue;
                    }
                    if (noise >= 0.1) {
                        this.setBlockType(x, y, z, BlockTypes.FIRE);
                        continue;
                    }
                    this.setBlockType(x, y, z, BlockTypes.AIR);
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.heatRay(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.heatRay(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom(TextColors.GREEN, "Octaves: " + this.octaves);
        vm.custom(TextColors.GREEN, "Persistence: " + this.persistence);
        vm.custom(TextColors.GREEN, "Frequency: " + this.frequency);
        vm.size();
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 0; i < par.length; ++i) {
            String parameter = par[i].toLowerCase();
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(TextColors.GOLD + "Heat Ray brush Parameters:");
                v.sendMessage(TextColors.AQUA + "/b hr oct[int] -- Octaves parameter for the noise generator.");
                v.sendMessage(TextColors.AQUA + "/b hr pers[float] -- Persistence parameter for the noise generator.");
                v.sendMessage(TextColors.AQUA + "/b hr freq[float] -- Frequency parameter for the noise generator.");
            }
            if (parameter.startsWith("oct")) {
                try {
                    this.octaves = Integer.valueOf(parameter.replace("oct", ""));
                    this.perlin.setOctaveCount(this.octaves);
                    v.getVoxelMessage().custom(TextColors.GREEN + "Octaves: " + this.octaves);
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid octave value.");
                }
                continue;
            }
            if (parameter.startsWith("pers")) {
                try {
                    this.persistence = Double.valueOf(parameter.replace("pers", ""));
                    this.perlin.setPersistence(this.persistence);
                    v.getVoxelMessage().custom(TextColors.GREEN + "Amplitude: " + this.persistence);
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid amplitude value.");
                }
                continue;
            }
            if (!parameter.startsWith("freq")) continue;
            try {
                this.frequency = Double.valueOf(parameter.replace("freq", ""));
                this.perlin.setFrequency(this.frequency);
                v.getVoxelMessage().custom(TextColors.GREEN + "Frequency: " + this.frequency);
                continue;
            }
            catch (NumberFormatException e) {
                v.sendMessage(TextColors.RED, "Invalid frequency value.");
            }
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.heatray";
    }

    static {
        FLAMABLE_BLOCKS.add(BlockTypes.WALL_SIGN);
        FLAMABLE_BLOCKS.add(BlockTypes.STANDING_SIGN);
        FLAMABLE_BLOCKS.add(BlockTypes.WOODEN_BUTTON);
        FLAMABLE_BLOCKS.add(BlockTypes.WOODEN_DOOR);
        FLAMABLE_BLOCKS.add(BlockTypes.RED_FLOWER);
        FLAMABLE_BLOCKS.add(BlockTypes.YELLOW_FLOWER);
        FLAMABLE_BLOCKS.add(BlockTypes.WOODEN_SLAB);
        FLAMABLE_BLOCKS.add(BlockTypes.DOUBLE_WOODEN_SLAB);
        FLAMABLE_BLOCKS.add(BlockTypes.TALLGRASS);
        FLAMABLE_BLOCKS.add(BlockTypes.PLANKS);
        FLAMABLE_BLOCKS.add(BlockTypes.ACACIA_DOOR);
        FLAMABLE_BLOCKS.add(BlockTypes.ACACIA_FENCE);
        FLAMABLE_BLOCKS.add(BlockTypes.ACACIA_FENCE_GATE);
        FLAMABLE_BLOCKS.add(BlockTypes.ACACIA_STAIRS);
        FLAMABLE_BLOCKS.add(BlockTypes.BIRCH_DOOR);
        FLAMABLE_BLOCKS.add(BlockTypes.BIRCH_FENCE);
        FLAMABLE_BLOCKS.add(BlockTypes.BIRCH_FENCE_GATE);
        FLAMABLE_BLOCKS.add(BlockTypes.BIRCH_STAIRS);
        FLAMABLE_BLOCKS.add(BlockTypes.FENCE);
        FLAMABLE_BLOCKS.add(BlockTypes.FENCE_GATE);
        FLAMABLE_BLOCKS.add(BlockTypes.OAK_STAIRS);
        FLAMABLE_BLOCKS.add(BlockTypes.BOOKSHELF);
        FLAMABLE_BLOCKS.add(BlockTypes.CARPET);
        FLAMABLE_BLOCKS.add(BlockTypes.COAL_BLOCK);
        FLAMABLE_BLOCKS.add(BlockTypes.CRAFTING_TABLE);
        FLAMABLE_BLOCKS.add(BlockTypes.DARK_OAK_DOOR);
        FLAMABLE_BLOCKS.add(BlockTypes.DARK_OAK_FENCE);
        FLAMABLE_BLOCKS.add(BlockTypes.DARK_OAK_FENCE_GATE);
        FLAMABLE_BLOCKS.add(BlockTypes.DARK_OAK_STAIRS);
        FLAMABLE_BLOCKS.add(BlockTypes.DEADBUSH);
        FLAMABLE_BLOCKS.add(BlockTypes.JUNGLE_DOOR);
        FLAMABLE_BLOCKS.add(BlockTypes.JUNGLE_FENCE);
        FLAMABLE_BLOCKS.add(BlockTypes.JUNGLE_FENCE_GATE);
        FLAMABLE_BLOCKS.add(BlockTypes.JUNGLE_STAIRS);
        FLAMABLE_BLOCKS.add(BlockTypes.LEAVES);
        FLAMABLE_BLOCKS.add(BlockTypes.LEAVES2);
        FLAMABLE_BLOCKS.add(BlockTypes.LOG);
        FLAMABLE_BLOCKS.add(BlockTypes.LOG2);
        FLAMABLE_BLOCKS.add(BlockTypes.TRAPDOOR);
        FLAMABLE_BLOCKS.add(BlockTypes.WOOL);
        FLAMABLE_BLOCKS.add(BlockTypes.SPRUCE_DOOR);
        FLAMABLE_BLOCKS.add(BlockTypes.SPRUCE_FENCE);
        FLAMABLE_BLOCKS.add(BlockTypes.SPRUCE_FENCE_GATE);
        FLAMABLE_BLOCKS.add(BlockTypes.SPRUCE_STAIRS);
    }
}

