/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.misc;

import com.flowpowered.math.vector.Vector3d;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.data.manipulator.mutable.entity.PassengerData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.text.format.TextColors;

public class JockeyBrush
extends Brush {
    private boolean inverse = false;
    private WeakReference<Entity> sittingEntity;

    public JockeyBrush() {
        this.setName("Jockey");
    }

    private void dismount(SnipeData v) {
        if (this.sittingEntity != null && this.sittingEntity.get() != null) {
            Entity entity = (Entity)this.sittingEntity.get();
            Optional data = entity.get(PassengerData.class);
            if (data.isPresent()) {
                Iterator it = ((PassengerData)data.get()).passengers().iterator();
                while (it.hasNext()) {
                    Optional re = entity.getWorld().getEntity((UUID)it.next());
                    if (!re.isPresent() || re.get() != v.owner().getPlayer()) continue;
                    it.remove();
                    break;
                }
                entity.offer((ValueContainer)data.get());
            }
            this.sittingEntity = null;
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.dismount(v);
        double distance = Double.MAX_VALUE;
        Entity nearest = null;
        Vector3d target = this.targetBlock.getPosition();
        Collection entities = this.inverse ? this.world.getEntities(e -> e instanceof Living) : this.world.getEntities();
        for (Entity e2 : entities) {
            double dist = e2.getLocation().getPosition().distanceSquared(target);
            if (!(dist < distance)) continue;
            nearest = e2;
        }
        if (nearest != null) {
            Optional data = nearest.getOrCreate(PassengerData.class);
            if (data.isPresent()) {
                PassengerData passengers = (PassengerData)data.get();
                passengers.addElement((Object)v.owner().getPlayer().getUniqueId());
                nearest.offer((ValueContainer)passengers);
            }
            this.sittingEntity = new WeakReference<Object>(nearest);
        }
    }

    @Override
    protected final void powder(SnipeData v) {
        v.owner().getPlayer().remove(PassengerData.class);
        this.dismount(v);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom(TextColors.AQUA, "Inverse jockey mode: ", this.inverse ? TextColors.GREEN : TextColors.RED, this.inverse ? "on" : "off");
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        if (par.length > 0 && par[0].equalsIgnoreCase("inverse")) {
            this.inverse = true;
            v.sendMessage(TextColors.GREEN, "Inverse jockey mode enabled");
        } else {
            this.inverse = false;
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.jockey";
    }
}

