/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.misc;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import com.thevoxelbox.voxelsniper.util.BlockBuffer;
import com.thevoxelbox.voxelsniper.util.Rot3d;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class Rot3DBrush
extends Brush {
    private double yaw;
    private double pitch;
    private double roll;
    private Rot3d rotUtil;

    public Rot3DBrush() {
        this.setName("Rotation");
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.brushMessage("Rotates a spherical area by a given yaw, pitch, and roll");
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        boolean changed = false;
        for (int i = 0; i < par.length; ++i) {
            String parameter = par[i];
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(TextColors.GOLD, "Rotate brush Parameters:");
                v.sendMessage(TextColors.AQUA, "p[0-359] -- set degrees of pitch rotation (rotation about the Z axis).");
                v.sendMessage(TextColors.BLUE, "r[0-359] -- set degrees of roll rotation (rotation about the X axis).");
                v.sendMessage(TextColors.LIGHT_PURPLE, "y[0-359] -- set degrees of yaw rotation (Rotation about the Y axis).");
                return;
            }
            if (parameter.startsWith("p")) {
                try {
                    if (this.pitch < 0.0 || this.pitch > 359.0) {
                        v.sendMessage(TextColors.RED + "Invalid brush parameters! Angles must be from 1-359");
                        continue;
                    }
                    this.pitch = Math.toRadians(Double.parseDouble(parameter.replace("p", "")));
                    v.sendMessage(TextColors.AQUA + "Around Z-axis degrees set to " + this.pitch);
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid pitch given.");
                }
                continue;
            }
            if (parameter.startsWith("r")) {
                try {
                    if (this.roll < 0.0 || this.roll > 359.0) {
                        v.sendMessage(TextColors.RED + "Invalid brush parameters! Angles must be from 1-359");
                        continue;
                    }
                    this.roll = Math.toRadians(Double.parseDouble(parameter.replace("r", "")));
                    v.sendMessage(TextColors.AQUA + "Around X-axis degrees set to " + this.roll);
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid roll given.");
                }
                continue;
            }
            if (!parameter.startsWith("y")) continue;
            try {
                if (this.yaw < 0.0 || this.yaw > 359.0) {
                    v.sendMessage(TextColors.RED + "Invalid brush parameters! Angles must be from 1-359");
                    continue;
                }
                this.yaw = Math.toRadians(Double.parseDouble(parameter.replace("y", "")));
                v.sendMessage(TextColors.AQUA + "Around Y-axis degrees set to " + this.yaw);
                continue;
            }
            catch (NumberFormatException e) {
                v.sendMessage(TextColors.RED, "Invalid yaw given.");
            }
        }
        if (this.rotUtil == null || changed) {
            this.rotUtil = new Rot3d(this.yaw, this.pitch, this.roll);
        }
    }

    private void rotate(SnipeData v, Location<World> targetBlock) {
        int z0;
        int z;
        int y0;
        int y;
        int x0;
        int x;
        int brushSize = GenericMath.floor((double)v.getBrushSize()) + 1;
        double brushSizeSquared = brushSize * brushSize;
        int tx = targetBlock.getBlockX();
        int ty = targetBlock.getBlockY();
        int tz = targetBlock.getBlockZ();
        BlockBuffer buffer = new BlockBuffer(new Vector3i(-brushSize, -brushSize, -brushSize), new Vector3i(brushSize, brushSize, brushSize));
        for (x = -brushSize; x <= brushSize; ++x) {
            x0 = tx + x;
            for (y = -brushSize; y <= brushSize; ++y) {
                y0 = ty + y;
                for (z = -brushSize; z <= brushSize; ++z) {
                    z0 = tz + z;
                    if ((double)(x * x + y * y + z * z) >= brushSizeSquared) continue;
                    Vector3d rot = this.rotUtil.rotate(x, y, z);
                    buffer.set(x + rot.getFloorX(), y + rot.getFloorY(), z + rot.getFloorZ(), this.world.getBlock(x0, y0, z0));
                }
            }
        }
        this.undo = new Undo(buffer.getBlockCount());
        for (x = -brushSize; x <= brushSize; ++x) {
            x0 = x + tx;
            for (y = -brushSize; y <= brushSize; ++y) {
                y0 = y + ty;
                for (z = -brushSize; z <= brushSize; ++z) {
                    z0 = z + tz;
                    if (!buffer.contains(x, y, z)) continue;
                    this.setBlockState(x0, y0, z0, buffer.get(x, y, z));
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.rotate(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.rotate(v, (Location<World>)this.lastBlock);
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.rot3d";
    }
}

