/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.misc;

import com.flowpowered.math.GenericMath;
import com.google.common.collect.Lists;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.tileentity.Sign;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.tileentity.SignData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SignOverwriteBrush
extends Brush {
    private List<Text> signTextLines = Lists.newArrayList((Object[])new Text[]{Text.of(), Text.of(), Text.of(), Text.of()});

    public SignOverwriteBrush() {
        this.setName("Sign Overwrite Brush");
    }

    private void setRanged(SnipeData v, Location<World> targetBlock) {
        double brushSize = v.getBrushSize();
        double brushSizeSquared = brushSize * brushSize;
        int tx = targetBlock.getBlockX();
        int ty = targetBlock.getBlockY();
        int tz = targetBlock.getBlockZ();
        int minx = GenericMath.floor((double)((double)targetBlock.getBlockX() - brushSize));
        int maxx = GenericMath.floor((double)((double)targetBlock.getBlockX() + brushSize)) + 1;
        int miny = Math.max(GenericMath.floor((double)((double)targetBlock.getBlockY() - brushSize)), 0);
        int maxy = Math.min(GenericMath.floor((double)((double)targetBlock.getBlockY() + brushSize)) + 1, WORLD_HEIGHT);
        int minz = GenericMath.floor((double)((double)targetBlock.getBlockZ() - brushSize));
        int maxz = GenericMath.floor((double)((double)targetBlock.getBlockZ() + brushSize)) + 1;
        boolean signFound = false;
        for (int x = minx; x <= maxx; ++x) {
            double xs = (tx - x) * (tx - x);
            for (int y = miny; y <= maxy; ++y) {
                double ys = (ty - y) * (ty - y);
                for (int z = minz; z <= maxz; ++z) {
                    Optional te;
                    BlockState block;
                    double zs = (tz - z) * (tz - z);
                    if (!(xs + ys + zs < brushSizeSquared) || (block = this.world.getBlock(x, y, z)).getType() != BlockTypes.STANDING_SIGN && block.getType() != BlockTypes.WALL_SIGN || !(te = this.world.getTileEntity(x, y, z)).isPresent()) continue;
                    Sign sign = (Sign)te.get();
                    SignData data = sign.getSignData();
                    data.set(Keys.SIGN_LINES, this.signTextLines);
                    sign.offer((ValueContainer)data);
                    signFound = true;
                }
            }
        }
        if (!signFound) {
            v.sendMessage(TextColors.RED + "Did not found any sign in selection box.");
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.setRanged(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        BlockState block = this.targetBlock.getBlock();
        if (block.getType() == BlockTypes.STANDING_SIGN || block.getType() == BlockTypes.WALL_SIGN) {
            Optional te = this.targetBlock.getTileEntity();
            if (te.isPresent()) {
                Sign sign = (Sign)te.get();
                SignData data = sign.getSignData();
                this.signTextLines = data.asList();
            }
            this.displayBuffer(v);
        } else {
            v.sendMessage(TextColors.RED + "Target block is not a sign.");
        }
    }

    private void displayBuffer(SnipeData v) {
        v.sendMessage(TextColors.BLUE + "Buffer text set to: ");
        for (int i = 0; i < this.signTextLines.size(); ++i) {
            v.sendMessage(i + ": ", this.signTextLines.get(i));
        }
    }

    @Override
    public final void info(Message vm) {
        vm.custom(TextColors.AQUA + "Sign Overwrite Brush Powder/Arrow:");
        vm.custom(TextColors.BLUE + "The arrow writes the internal line buffer to the tearget sign.");
        vm.custom(TextColors.BLUE + "The powder reads the text of the target sign into the internal buffer.");
        vm.custom(TextColors.BLUE + "Buffer text set to: ");
        for (int i = 0; i < this.signTextLines.size(); ++i) {
            vm.custom(i + ": ", this.signTextLines.get(i));
        }
        vm.size();
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.signoverwrite";
    }
}

