/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.misc;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.util.Optional;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.property.block.SolidCubeProperty;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SnowConeBrush
extends Brush {
    private void addSnow(SnipeData v, Location<World> targetBlock) {
        double brushSize = v.getBrushSize();
        double brushSizeSquared = brushSize * brushSize;
        int tx = targetBlock.getBlockX();
        int tz = targetBlock.getBlockZ();
        int minx = GenericMath.floor((double)((double)targetBlock.getBlockX() - brushSize));
        int maxx = GenericMath.floor((double)((double)targetBlock.getBlockX() + brushSize)) + 1;
        int miny = Math.max(GenericMath.floor((double)((double)targetBlock.getBlockY() - brushSize)), 0);
        int maxy = Math.min(GenericMath.floor((double)((double)targetBlock.getBlockY() + brushSize)) + 1, WORLD_HEIGHT - 1);
        int minz = GenericMath.floor((double)((double)targetBlock.getBlockZ() - brushSize));
        int maxz = GenericMath.floor((double)((double)targetBlock.getBlockZ() + brushSize)) + 1;
        this.undo = new Undo(GenericMath.floor((double)((brushSize + 1.0) * (brushSize + 1.0))));
        for (int x = minx; x <= maxx; ++x) {
            double xs = (tx - x) * (tx - x);
            for (int z = minz; z <= maxz; ++z) {
                BlockType above;
                int y;
                double zs = (tz - z) * (tz - z);
                if (!(xs + zs < brushSizeSquared)) continue;
                boolean topFound = false;
                for (y = maxy; y >= miny; --y) {
                    if (this.world.getBlockType(x, y, z) == BlockTypes.AIR) continue;
                    topFound = true;
                    break;
                }
                if (!topFound || y == maxy && (above = this.world.getBlock(x, y + 1, z).getType()) != BlockTypes.AIR) continue;
                BlockState block = this.world.getBlock(x, y, z);
                if (block.getType() == BlockTypes.SNOW_LAYER) {
                    Optional height = block.get(Keys.LAYER);
                    if (!height.isPresent()) {
                        BlockState newSnow = (BlockState)BlockTypes.SNOW_LAYER.getDefaultState().with(Keys.LAYER, (Object)2).get();
                        this.setBlockState(x, y, z, newSnow);
                        continue;
                    }
                    int sheight = (Integer)height.get();
                    if (sheight == (Integer)((MutableBoundedValue)block.getValue(Keys.LAYER).get()).getMaxValue()) {
                        this.setBlockType(x, y, z, BlockTypes.SNOW);
                        this.setBlockType(x, y + 1, z, BlockTypes.SNOW_LAYER);
                        continue;
                    }
                    BlockState newSnow = (BlockState)BlockTypes.SNOW_LAYER.getDefaultState().with(Keys.LAYER, (Object)(sheight + 1)).get();
                    this.setBlockState(x, y, z, newSnow);
                    continue;
                }
                if (block.getType() == BlockTypes.WATER || block.getType() == BlockTypes.FLOWING_WATER) {
                    this.setBlockType(x, y, z, BlockTypes.ICE);
                    continue;
                }
                Optional prop = block.getProperty(SolidCubeProperty.class);
                if (!prop.isPresent() || !((Boolean)((SolidCubeProperty)prop.get()).getValue()).booleanValue()) continue;
                this.setBlockType(x, y + 1, z, BlockTypes.SNOW_LAYER);
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.addSnow(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.addSnow(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName("Snow Cone");
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.snowcone";
    }
}

