/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.misc;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.io.File;
import java.util.HashMap;
import java.util.Scanner;
import org.spongepowered.api.text.format.TextColors;

public class StencilListBrush
extends Brush {
    private byte pasteOption = 1;
    private String filename = "NoFileLoaded";
    private short x;
    private short z;
    private short y;
    private short xRef;
    private short zRef;
    private short yRef;
    private byte pasteParam = 0;
    private HashMap<Integer, String> stencilList = new HashMap();

    public StencilListBrush() {
        this.setName("StencilList");
    }

    private String readRandomStencil(SnipeData v) {
        double rand = Math.random() * (double)this.stencilList.size();
        int choice = (int)rand;
        return this.stencilList.get(choice);
    }

    private void readStencilList(String listname, SnipeData v) {
        File file = new File("plugins/VoxelSniper/stencilLists/" + this.filename + ".txt");
        if (file.exists()) {
            try (Scanner scanner = new Scanner(file);){
                int counter = 0;
                while (scanner.hasNext()) {
                    this.stencilList.put(counter, scanner.nextLine());
                    ++counter;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void stencilPaste(SnipeData v) {
    }

    private void stencilPasteRotation(SnipeData v) {
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.stencilPaste(v);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.stencilPasteRotation(v);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom("File loaded: " + this.filename);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        if (par[1].equalsIgnoreCase("info")) {
            v.sendMessage(TextColors.GOLD, "Stencil List brush Parameters:");
            v.sendMessage(TextColors.AQUA, "/b schem [optional: 'full' 'fill' or 'replace', with fill as default] [name] -- Loads the specified stencil list.  Full/fill/replace must come first.  Full = paste all blocks, fill = paste only into air blocks, replace = paste full blocks in only, but replace anything in their way.");
            return;
        }
        if (par[1].equalsIgnoreCase("full")) {
            this.pasteOption = 0;
            this.pasteParam = 1;
        } else if (par[1].equalsIgnoreCase("fill")) {
            this.pasteOption = 1;
            this.pasteParam = 1;
        } else if (par[1].equalsIgnoreCase("replace")) {
            this.pasteOption = (byte)2;
            this.pasteParam = 1;
        }
        try {
            this.filename = par[1 + this.pasteParam];
            File file = new File("plugins/VoxelSniper/stencilLists/" + this.filename + ".txt");
            if (file.exists()) {
                v.sendMessage(TextColors.RED, "Stencil List '" + this.filename + "' exists and was loaded.");
                this.readStencilList(this.filename, v);
            } else {
                v.sendMessage(TextColors.AQUA, "Stencil List '" + this.filename + "' does not exist.  This brush will not function without a valid stencil list.");
                this.filename = "NoFileLoaded";
            }
        }
        catch (Exception exception) {
            v.sendMessage(TextColors.RED, "You need to type a stencil name.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.stencillist";
    }
}

