/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.misc;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.util.Optional;
import java.util.Random;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.gen.PopulatorObject;
import org.spongepowered.api.world.gen.type.BiomeTreeType;
import org.spongepowered.api.world.gen.type.BiomeTreeTypes;

public class TreeSnipeBrush
extends Brush {
    private Random random = new Random();
    private BiomeTreeType treeType = BiomeTreeTypes.OAK;
    private boolean large = false;

    public TreeSnipeBrush() {
        this.setName("Tree Snipe");
    }

    private void single(SnipeData v, Location<World> targetBlock) {
        Optional obj;
        if (this.large && (obj = this.treeType.getLargePopulatorObject()).isPresent()) {
            ((PopulatorObject)obj.get()).placeObject(this.world, this.random, targetBlock.getBlockX(), targetBlock.getBlockY(), targetBlock.getBlockZ());
            return;
        }
        this.treeType.getPopulatorObject().placeObject(this.world, this.random, targetBlock.getBlockX(), targetBlock.getBlockY(), targetBlock.getBlockZ());
    }

    private int getYOffset() {
        int y = 1;
        int y0 = this.targetBlock.getBlockY() + y;
        while (y0 < Brush.WORLD_HEIGHT && this.world.getBlockType(this.targetBlock.getBlockX(), y0, this.targetBlock.getBlockZ()) != BlockTypes.AIR) {
            y0 = this.targetBlock.getBlockY() + ++y;
        }
        return y;
    }

    private void printTreeType(Message vm) {
        vm.custom(TextColors.AQUA, "Currently selected tree type: ", TextColors.GRAY, this.treeType.getId() + (this.large ? "_large" : ""));
    }

    @Override
    protected final void arrow(SnipeData v) {
        Location targetBlock = this.targetBlock.add(0.0, (double)this.getYOffset(), 0.0);
        this.single(v, (Location<World>)targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.single(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        this.printTreeType(vm);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        Optional tree;
        if (par.length == 0 || par[0].equalsIgnoreCase("info")) {
            v.sendMessage(TextColors.GOLD + "Tree snipe brush:");
            v.sendMessage(TextColors.AQUA + "/b t treetype");
            this.printTreeType(v.getVoxelMessage());
            return;
        }
        if (par[0].equalsIgnoreCase("types")) {
            StringBuilder types = new StringBuilder();
            for (BiomeTreeType type : Sponge.getRegistry().getAllOf(BiomeTreeType.class)) {
                types.append(", ").append(type.getId());
                if (!type.getLargePopulatorObject().isPresent()) continue;
                types.append(", ").append(type.getId() + "_large");
            }
            v.sendMessage(TextColors.AQUA, "Available tree types:");
            v.sendMessage(types.toString().substring(2));
            return;
        }
        String typename = par[0];
        boolean large = false;
        if (typename.endsWith("_large")) {
            typename = typename.substring(0, typename.length() - 6);
            large = true;
        }
        if ((tree = Sponge.getRegistry().getType(BiomeTreeType.class, typename)).isPresent()) {
            this.treeType = (BiomeTreeType)tree.get();
            this.large = false;
            if (large) {
                if (!this.treeType.getLargePopulatorObject().isPresent()) {
                    v.sendMessage(TextColors.RED, "No large tree for that type");
                    return;
                }
                this.large = true;
            }
        } else {
            v.sendMessage(TextColors.RED, "Tree type not found. Use '/b tree types' to list all types.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.treesnipe";
    }
}

