/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class BallBrush
extends PerformBrush {
    public BallBrush() {
        this.setName("Ball");
    }

    private void ball(SnipeData v, Location<World> targetBlock) {
        double brushSize = v.getBrushSize();
        double brushSizeSquared = brushSize * brushSize;
        int tx = targetBlock.getBlockX();
        int ty = targetBlock.getBlockY();
        int tz = targetBlock.getBlockZ();
        int minx = GenericMath.floor((double)((double)targetBlock.getBlockX() - brushSize));
        int maxx = GenericMath.floor((double)((double)targetBlock.getBlockX() + brushSize)) + 1;
        int miny = Math.max(GenericMath.floor((double)((double)targetBlock.getBlockY() - brushSize)), 0);
        int maxy = Math.min(GenericMath.floor((double)((double)targetBlock.getBlockY() + brushSize)) + 1, WORLD_HEIGHT);
        int minz = GenericMath.floor((double)((double)targetBlock.getBlockZ() - brushSize));
        int maxz = GenericMath.floor((double)((double)targetBlock.getBlockZ() + brushSize)) + 1;
        this.undo = new Undo(GenericMath.floor((double)(Math.PI * 4 * (brushSize + 1.0) * (brushSize + 1.0) * (brushSize + 1.0) / 3.0)));
        for (int x = maxx; x >= minx; --x) {
            double xs = (tx - x) * (tx - x);
            for (int y = maxy; y >= miny; --y) {
                double ys = (ty - y) * (ty - y);
                for (int z = maxz; z >= minz; --z) {
                    double zs = (tz - z) * (tz - z);
                    if (!(xs + ys + zs < brushSizeSquared)) continue;
                    this.perform(v, x, y, z);
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected void arrow(SnipeData v) {
        this.ball(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected void powder(SnipeData v) {
        this.ball(v, (Location<World>)this.lastBlock);
    }

    @Override
    public void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.ball";
    }
}

