/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import java.util.Random;
import org.spongepowered.api.text.format.TextColors;

public class BlobBrush
extends PerformBrush {
    private static final double GROW_PERCENT_DEFAULT = 0.1;
    private static final double GROW_PERCENT_MIN = 0.0;
    private static final double GROW_PERCENT_MAX = 1.0;
    private Random randomGenerator = new Random();
    private double growPercent = 0.1;

    public BlobBrush() {
        this.setName("Blob");
    }

    private void digBlob(SnipeData v) {
        int brushSize = (int)v.getBrushSize();
        int brushSizeDoubled = 2 * brushSize;
        int[][][] splat = new int[brushSizeDoubled + 1][brushSizeDoubled + 1][brushSizeDoubled + 1];
        int[][][] tempSplat = new int[brushSizeDoubled + 1][brushSizeDoubled + 1][brushSizeDoubled + 1];
        this.undo = new Undo(brushSizeDoubled * brushSizeDoubled * brushSizeDoubled);
        for (int x = brushSizeDoubled; x >= 0; --x) {
            for (int y = brushSizeDoubled; y >= 0; --y) {
                for (int z = brushSizeDoubled; z >= 0; --z) {
                    splat[x][y][z] = (x == 0 || y == 0 | z == 0 || x == brushSizeDoubled || y == brushSizeDoubled || z == brushSizeDoubled) && this.randomGenerator.nextDouble() <= this.growPercent ? 0 : 1;
                }
            }
        }
        for (int r = 0; r < brushSize; ++r) {
            int z;
            int y;
            int x;
            for (x = brushSizeDoubled; x >= 0; --x) {
                for (y = brushSizeDoubled; y >= 0; --y) {
                    for (z = brushSizeDoubled; z >= 0; --z) {
                        tempSplat[x][y][z] = splat[x][y][z];
                        double growCheck = 0.0;
                        if (splat[x][y][z] == 1) {
                            if (x != 0 && splat[x - 1][y][z] == 0) {
                                growCheck += 1.0;
                            }
                            if (y != 0 && splat[x][y - 1][z] == 0) {
                                growCheck += 1.0;
                            }
                            if (z != 0 && splat[x][y][z - 1] == 0) {
                                growCheck += 1.0;
                            }
                            if (x != 2 * brushSize && splat[x + 1][y][z] == 0) {
                                growCheck += 1.0;
                            }
                            if (y != 2 * brushSize && splat[x][y + 1][z] == 0) {
                                growCheck += 1.0;
                            }
                            if (z != 2 * brushSize && splat[x][y][z + 1] == 0) {
                                growCheck += 1.0;
                            }
                        }
                        if (!(growCheck >= 1.0) || !(this.randomGenerator.nextDouble() <= this.growPercent)) continue;
                        tempSplat[x][y][z] = 0;
                    }
                }
            }
            for (x = brushSizeDoubled; x >= 0; --x) {
                for (y = brushSizeDoubled; y >= 0; --y) {
                    for (z = brushSizeDoubled; z >= 0; --z) {
                        splat[x][y][z] = tempSplat[x][y][z];
                    }
                }
            }
        }
        double rSquared = Math.pow(brushSize + 1, 2.0);
        for (int x = brushSizeDoubled; x >= 0; --x) {
            double xSquared = Math.pow(x - brushSize - 1, 2.0);
            for (int y = brushSizeDoubled; y >= 0; --y) {
                double ySquared = Math.pow(y - brushSize - 1, 2.0);
                for (int z = brushSizeDoubled; z >= 0; --z) {
                    if (splat[x][y][z] != 1 || !(xSquared + ySquared + Math.pow(z - brushSize - 1, 2.0) <= rSquared)) continue;
                    this.perform(v, this.targetBlock.getBlockX() - brushSize + x, this.targetBlock.getBlockY() - brushSize + z, this.targetBlock.getBlockZ() - brushSize + y);
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    private void growBlob(SnipeData v) {
        int brushSize = (int)v.getBrushSize();
        int brushSizeDoubled = 2 * brushSize;
        int[][][] splat = new int[brushSizeDoubled + 1][brushSizeDoubled + 1][brushSizeDoubled + 1];
        int[][][] tempSplat = new int[brushSizeDoubled + 1][brushSizeDoubled + 1][brushSizeDoubled + 1];
        this.undo = new Undo(brushSizeDoubled * brushSizeDoubled * brushSizeDoubled);
        splat[brushSize][brushSize][brushSize] = 1;
        for (int r = 0; r < brushSize; ++r) {
            int z;
            int y;
            int x;
            for (x = brushSizeDoubled; x >= 0; --x) {
                for (y = brushSizeDoubled; y >= 0; --y) {
                    for (z = brushSizeDoubled; z >= 0; --z) {
                        tempSplat[x][y][z] = splat[x][y][z];
                        int growCheck = 0;
                        if (splat[x][y][z] == 0) {
                            if (x != 0 && splat[x - 1][y][z] == 1) {
                                ++growCheck;
                            }
                            if (y != 0 && splat[x][y - 1][z] == 1) {
                                ++growCheck;
                            }
                            if (z != 0 && splat[x][y][z - 1] == 1) {
                                ++growCheck;
                            }
                            if (x != 2 * brushSize && splat[x + 1][y][z] == 1) {
                                ++growCheck;
                            }
                            if (y != 2 * brushSize && splat[x][y + 1][z] == 1) {
                                ++growCheck;
                            }
                            if (z != 2 * brushSize && splat[x][y][z + 1] == 1) {
                                ++growCheck;
                            }
                        }
                        if (growCheck < true || !(this.randomGenerator.nextDouble() <= this.growPercent)) continue;
                        tempSplat[x][y][z] = 1;
                    }
                }
            }
            for (x = brushSizeDoubled; x >= 0; --x) {
                for (y = brushSizeDoubled; y >= 0; --y) {
                    for (z = brushSizeDoubled; z >= 0; --z) {
                        splat[x][y][z] = tempSplat[x][y][z];
                    }
                }
            }
        }
        double rSquared = Math.pow(brushSize + 1, 2.0);
        for (int x = brushSizeDoubled; x >= 0; --x) {
            double xSquared = Math.pow(x - brushSize - 1, 2.0);
            for (int y = brushSizeDoubled; y >= 0; --y) {
                double ySquared = Math.pow(y - brushSize - 1, 2.0);
                for (int z = brushSizeDoubled; z >= 0; --z) {
                    if (splat[x][y][z] != 1 || !(xSquared + ySquared + Math.pow(z - brushSize - 1, 2.0) <= rSquared)) continue;
                    this.perform(v, this.targetBlock.getBlockX() - brushSize + x, this.targetBlock.getBlockY() - brushSize + z, this.targetBlock.getBlockZ() - brushSize + y);
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.growBlob(v);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.digBlob(v);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.custom(TextColors.BLUE, "Growth percent set to: " + this.growPercent + "%");
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        block6: {
            if (par.length == 0 || par[0].equalsIgnoreCase("info")) {
                v.sendMessage(TextColors.GOLD, "Blob brush Parameters:");
                v.sendMessage(TextColors.AQUA, "/b blob g[double] -- set a growth percentage (0.0-1.0). Default is 0.1");
                return;
            }
            if (par[0].startsWith("g")) {
                try {
                    double temp = Double.parseDouble(par[0].replace("g", ""));
                    if (temp >= 0.0 && temp <= 1.0) {
                        v.sendMessage(TextColors.AQUA, "Growth percent set to: " + temp + "%");
                        this.growPercent = temp;
                        break block6;
                    }
                    v.sendMessage(TextColors.RED, "Growth percent must be an integer 0.0-1.0!");
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Growth percent must be an integer 0.0-1.0!");
                }
            } else {
                v.sendMessage(TextColors.RED, "Invalid brush parameters! use the info parameter to display parameter info.");
            }
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.blob";
    }
}

