/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class CheckerVoxelDiscBrush
extends PerformBrush {
    private boolean useWorldCoordinates = true;

    public CheckerVoxelDiscBrush() {
        this.setName("Checker Voxel Disc");
    }

    private void applyBrush(SnipeData v, Location<World> targetBlock) {
        double brushSize = v.getBrushSize();
        int tx = targetBlock.getBlockX();
        int tz = targetBlock.getBlockZ();
        int minx = GenericMath.floor((double)((double)targetBlock.getBlockX() - brushSize));
        int maxx = GenericMath.floor((double)((double)targetBlock.getBlockX() + brushSize)) + 1;
        int minz = GenericMath.floor((double)((double)targetBlock.getBlockZ() - brushSize));
        int maxz = GenericMath.floor((double)((double)targetBlock.getBlockZ() + brushSize)) + 1;
        this.undo = new Undo(GenericMath.floor((double)(Math.PI * (brushSize + 1.0) * (brushSize + 1.0))));
        for (int x = minx; x <= maxx; ++x) {
            for (int z = minz; z <= maxz; ++z) {
                int sum;
                int n = sum = this.useWorldCoordinates ? x + z : x - tx + z - tz;
                if (sum % 2 == 0) continue;
                this.perform(v, x, targetBlock.getBlockY(), z);
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.applyBrush(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.applyBrush(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
    }

    @Override
    public void parameters(String[] par, SnipeData v) {
        if (par.length == 0) {
            return;
        }
        if (par[0].equals("info")) {
            v.sendMessage(TextColors.GOLD, this.getName() + " Parameters:");
            v.sendMessage(TextColors.AQUA, "true  -- Enables using World Coordinates.");
            v.sendMessage(TextColors.AQUA, "false -- Disables using World Coordinates.");
            return;
        }
        if (par[0].startsWith("true")) {
            this.useWorldCoordinates = true;
            v.sendMessage(TextColors.AQUA, "Enabled using World Coordinates.");
        } else if (par[0].startsWith("false")) {
            this.useWorldCoordinates = false;
            v.sendMessage(TextColors.AQUA, "Disabled using World Coordinates.");
        } else {
            v.sendMessage(TextColors.RED, "Invalid brush parameters! use the info parameter to display parameter info.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.checkervoxeldisc";
    }
}

