/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class CylinderBrush
extends PerformBrush {
    public CylinderBrush() {
        this.setName("Cylinder");
    }

    private void cylinder(SnipeData v, Location<World> targetBlock) {
        int yStartingPoint = targetBlock.getBlockY() + v.getcCen();
        int yEndPoint = targetBlock.getBlockY() + v.getVoxelHeight() + v.getcCen();
        if (yEndPoint < yStartingPoint) {
            yEndPoint = yStartingPoint;
        }
        if (yStartingPoint < 0) {
            yStartingPoint = 0;
        } else if (yStartingPoint > WORLD_HEIGHT) {
            yStartingPoint = WORLD_HEIGHT;
        }
        if (yEndPoint < 0) {
            yEndPoint = 0;
        } else if (yEndPoint > WORLD_HEIGHT) {
            yEndPoint = WORLD_HEIGHT;
        }
        double brushSize = v.getBrushSize();
        double brushSizeSquared = brushSize * brushSize;
        int tx = targetBlock.getBlockX();
        int tz = targetBlock.getBlockZ();
        int minx = GenericMath.floor((double)((double)targetBlock.getBlockX() - brushSize));
        int maxx = GenericMath.floor((double)((double)targetBlock.getBlockX() + brushSize)) + 1;
        int minz = GenericMath.floor((double)((double)targetBlock.getBlockZ() - brushSize));
        int maxz = GenericMath.floor((double)((double)targetBlock.getBlockZ() + brushSize)) + 1;
        this.undo = new Undo(GenericMath.floor((double)(Math.PI * (brushSize + 1.0) * (brushSize + 1.0))));
        for (int x = minx; x <= maxx; ++x) {
            double xs = (tx - x) * (tx - x);
            for (int z = minz; z <= maxz; ++z) {
                double zs = (tz - z) * (tz - z);
                if (!(xs + zs < brushSizeSquared)) continue;
                for (int y = yEndPoint; y >= yStartingPoint; --y) {
                    this.perform(v, x, y, z);
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.cylinder(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.cylinder(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.height();
        vm.center();
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 0; i < par.length; ++i) {
            String parameter = par[i];
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(TextColors.GOLD + "Cylinder Brush Parameters:");
                v.sendMessage(TextColors.AQUA + "/b c h[number] -- set the cylinder v.voxelHeight.  Default is 1.");
                v.sendMessage(TextColors.DARK_BLUE + "/b c c[number] -- set the origin of the cylinder compared to the target block. Positive numbers will move the cylinder upward, negative will move it downward.");
                return;
            }
            if (parameter.startsWith("h")) {
                try {
                    v.setVoxelHeight((int)Double.parseDouble(parameter.replace("h", "")));
                    v.sendMessage(TextColors.AQUA + "Cylinder v.voxelHeight set to: " + v.getVoxelHeight());
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid height given.");
                }
                continue;
            }
            if (parameter.startsWith("c")) {
                try {
                    v.setcCen((int)Double.parseDouble(parameter.replace("c", "")));
                    v.sendMessage(TextColors.AQUA + "Cylinder origin set to: " + v.getcCen());
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid origin given.");
                }
                continue;
            }
            v.sendMessage(TextColors.RED + "Invalid brush parameters! use the info parameter to display parameter info.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.cylinder";
    }
}

