/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class DiscBrush
extends PerformBrush {
    public DiscBrush() {
        this.setName("Disc");
    }

    private void disc(SnipeData v, Location<World> targetBlock) {
        double brushSize = v.getBrushSize();
        double brushSizeSquared = brushSize * brushSize;
        int tx = targetBlock.getBlockX();
        int tz = targetBlock.getBlockZ();
        int minx = GenericMath.floor((double)((double)targetBlock.getBlockX() - brushSize));
        int maxx = GenericMath.floor((double)((double)targetBlock.getBlockX() + brushSize)) + 1;
        int minz = GenericMath.floor((double)((double)targetBlock.getBlockZ() - brushSize));
        int maxz = GenericMath.floor((double)((double)targetBlock.getBlockZ() + brushSize)) + 1;
        this.undo = new Undo(GenericMath.floor((double)(Math.PI * (brushSize + 1.0) * (brushSize + 1.0))));
        for (int x = minx; x <= maxx; ++x) {
            double xs = (tx - x) * (tx - x);
            for (int z = minz; z <= maxz; ++z) {
                double zs = (tz - z) * (tz - z);
                if (!(xs + zs < brushSizeSquared)) continue;
                this.perform(v, x, targetBlock.getBlockY(), z);
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.disc(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.disc(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.disc";
    }
}

