/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class DiscFaceBrush
extends PerformBrush {
    public DiscFaceBrush() {
        this.setName("Disc Face");
    }

    private void disc(SnipeData v, Location<World> targetBlock, Direction axis) {
        double brushSize = v.getBrushSize();
        double brushSizeSquared = brushSize * brushSize;
        int tx = targetBlock.getBlockX();
        int ty = targetBlock.getBlockY();
        int tz = targetBlock.getBlockZ();
        this.undo = new Undo(GenericMath.floor((double)(Math.PI * (brushSize + 1.0) * (brushSize + 1.0))));
        int size = GenericMath.floor((double)brushSize) + 1;
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                if (!((double)(x * x + z * z) < brushSizeSquared)) continue;
                if (axis == Direction.UP) {
                    this.perform(v, x + tx, targetBlock.getBlockY(), z + tz);
                    continue;
                }
                if (axis == Direction.NORTH) {
                    this.perform(v, x + tx, z + ty, targetBlock.getBlockZ());
                    continue;
                }
                if (axis != Direction.EAST) continue;
                this.perform(v, targetBlock.getBlockX(), x + ty, z + tz);
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    private void pre(SnipeData v, Location<World> target) {
        if (this.lastBlock.getBlockY() != this.targetBlock.getBlockY()) {
            this.disc(v, target, Direction.UP);
        } else if (this.lastBlock.getBlockX() != this.targetBlock.getBlockX()) {
            this.disc(v, target, Direction.EAST);
        } else if (this.lastBlock.getBlockZ() != this.targetBlock.getBlockZ()) {
            this.disc(v, target, Direction.NORTH);
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.pre(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.pre(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.discface";
    }
}

