/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class EllipseBrush
extends PerformBrush {
    private double xrad = -1.0;
    private double yrad = -1.0;

    public EllipseBrush() {
        this.setName("Ellipse");
    }

    private void ellipse(SnipeData v, Location<World> targetBlock, Direction axis) {
        double xrads = this.xrad * this.xrad;
        double yrads = this.yrad * this.yrad;
        int tx = targetBlock.getBlockX();
        int tz = targetBlock.getBlockZ();
        int minx = GenericMath.floor((double)((double)targetBlock.getBlockX() - this.xrad));
        int maxx = (int)Math.ceil((double)targetBlock.getBlockX() + this.xrad);
        int minz = GenericMath.floor((double)((double)targetBlock.getBlockZ() - this.yrad));
        int maxz = (int)Math.ceil((double)targetBlock.getBlockZ() + this.yrad);
        this.undo = new Undo(GenericMath.floor((double)(Math.PI * (this.xrad + 1.0) * (this.yrad + 1.0))));
        for (int x = minx; x <= maxx; ++x) {
            double xs = (tx - x) * (tx - x);
            for (int z = minz; z <= maxz; ++z) {
                double zs = (tz - z) * (tz - z);
                if (!(xs / xrads + zs / yrads < 1.0)) continue;
                if (axis == Direction.UP) {
                    this.perform(v, x, targetBlock.getBlockY(), z);
                    continue;
                }
                if (axis == Direction.NORTH) {
                    this.perform(v, x, z, targetBlock.getBlockZ());
                    continue;
                }
                if (axis != Direction.EAST) continue;
                this.perform(v, targetBlock.getBlockX(), x, z);
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    private void pre(SnipeData v, Location<World> target) {
        if (this.lastBlock.getBlockY() != this.targetBlock.getBlockY()) {
            this.ellipse(v, target, Direction.UP);
        } else if (this.lastBlock.getBlockX() != this.targetBlock.getBlockX()) {
            this.ellipse(v, target, Direction.EAST);
        } else if (this.lastBlock.getBlockZ() != this.targetBlock.getBlockZ()) {
            this.ellipse(v, target, Direction.NORTH);
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.pre(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.pre(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom(TextColors.AQUA, "X-radius set to: ", TextColors.DARK_AQUA, this.xrad);
        vm.custom(TextColors.AQUA, "Y-radius set to: ", TextColors.DARK_AQUA, this.yrad);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 0; i < par.length; ++i) {
            String parameter = par[i];
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(TextColors.GOLD, "Ellipse brush parameters");
                v.sendMessage(TextColors.AQUA, "  x[n]: Set X radius to n");
                v.sendMessage(TextColors.AQUA, "  y[n]: Set Y radius to n");
                return;
            }
            if (parameter.startsWith("x")) {
                try {
                    double val = Double.parseDouble(parameter.replace("x", ""));
                    if (val <= 0.0) {
                        v.sendMessage(TextColors.RED, "X radius must be greater than zero.");
                        continue;
                    }
                    this.xrad = val;
                    v.sendMessage(TextColors.GREEN, "X radius  set to " + this.xrad);
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid X radius value.");
                }
                continue;
            }
            if (parameter.startsWith("y")) {
                try {
                    double val = Double.parseDouble(parameter.replace("y", ""));
                    if (val <= 0.0) {
                        v.sendMessage(TextColors.RED, "Y radius must be greater than zero.");
                        continue;
                    }
                    this.yrad = val;
                    v.sendMessage(TextColors.GREEN, "Y radius  set to " + this.yrad);
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid Y radius value.");
                }
                continue;
            }
            v.sendMessage(TextColors.RED + "Invalid brush parameters! Use the \"info\" parameter to display parameter info.");
        }
        if (this.xrad <= 0.0) {
            this.xrad = v.getBrushSize();
            v.sendMessage(TextColors.GREEN, "X radius  set to " + this.xrad);
        }
        if (this.yrad <= 0.0) {
            this.yrad = v.getBrushSize();
            v.sendMessage(TextColors.GREEN, "Y radius  set to " + this.yrad);
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.ellipse";
    }
}

