/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class EllipsoidBrush
extends PerformBrush {
    private double xrad = -1.0;
    private double yrad = -1.0;
    private double zrad = -1.0;

    public EllipsoidBrush() {
        this.setName("Ellipsoid");
    }

    private void ellipsoid(SnipeData v, Location<World> targetBlock) {
        double xrads = this.xrad * this.xrad;
        double yrads = this.yrad * this.yrad;
        double zrads = this.zrad * this.zrad;
        int tx = targetBlock.getBlockX();
        int ty = targetBlock.getBlockY();
        int tz = targetBlock.getBlockZ();
        int minx = GenericMath.floor((double)((double)targetBlock.getBlockX() - this.xrad));
        int maxx = GenericMath.floor((double)((double)targetBlock.getBlockX() + this.xrad)) + 1;
        int miny = Math.max(GenericMath.floor((double)((double)targetBlock.getBlockY() - this.yrad)), 0);
        int maxy = Math.min(GenericMath.floor((double)((double)targetBlock.getBlockY() + this.yrad)) + 1, WORLD_HEIGHT);
        int minz = GenericMath.floor((double)((double)targetBlock.getBlockZ() - this.zrad));
        int maxz = GenericMath.floor((double)((double)targetBlock.getBlockZ() + this.zrad)) + 1;
        this.undo = new Undo(GenericMath.floor((double)(Math.PI * 4 * (this.xrad + 1.0) * (this.yrad + 1.0) * (this.zrad + 1.0) / 3.0)));
        for (int x = maxx; x >= minx; --x) {
            double xs = (tx - x) * (tx - x);
            for (int y = maxy; y >= miny; --y) {
                double ys = (ty - y) * (ty - y);
                for (int z = maxz; z >= minz; --z) {
                    double zs = (tz - z) * (tz - z);
                    if (!(xs / xrads + ys / yrads + zs / zrads < 1.0)) continue;
                    this.perform(v, x, y, z);
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.ellipsoid(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.ellipsoid(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom(TextColors.AQUA, "X-radius set to: ", TextColors.DARK_AQUA, this.xrad);
        vm.custom(TextColors.AQUA, "Y-radius set to: ", TextColors.DARK_AQUA, this.yrad);
        vm.custom(TextColors.AQUA, "Z-radius set to: ", TextColors.DARK_AQUA, this.zrad);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 0; i < par.length; ++i) {
            String parameter = par[i];
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(TextColors.GOLD + "Ellipse brush parameters");
                v.sendMessage(TextColors.AQUA + "x[n]: Set X radius to n");
                v.sendMessage(TextColors.AQUA + "y[n]: Set Y radius to n");
                v.sendMessage(TextColors.AQUA + "z[n]: Set Z radius to n");
                return;
            }
            if (parameter.startsWith("x")) {
                try {
                    double val = Double.parseDouble(parameter.replace("x", ""));
                    if (val <= 0.0) {
                        v.sendMessage(TextColors.RED, "X radius must be greater than zero.");
                        continue;
                    }
                    this.xrad = val;
                    v.sendMessage(TextColors.GREEN, "X radius  set to " + this.xrad);
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid X radius value.");
                }
                continue;
            }
            if (parameter.startsWith("y")) {
                try {
                    double val = Double.parseDouble(parameter.replace("y", ""));
                    if (val <= 0.0) {
                        v.sendMessage(TextColors.RED, "Y radius must be greater than zero.");
                        continue;
                    }
                    this.yrad = val;
                    v.sendMessage(TextColors.GREEN, "Y radius  set to " + this.yrad);
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid Y radius value.");
                }
                continue;
            }
            if (parameter.startsWith("z")) {
                try {
                    double val = Double.parseDouble(parameter.replace("z", ""));
                    if (val <= 0.0) {
                        v.sendMessage(TextColors.RED, "Z radius must be greater than zero.");
                        continue;
                    }
                    this.zrad = val;
                    v.sendMessage(TextColors.GREEN, "Z radius  set to " + this.zrad);
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid Z radius value.");
                }
                continue;
            }
            v.sendMessage(TextColors.RED + "Invalid brush parameters! Use the \"info\" parameter to display parameter info.");
        }
        if (this.xrad <= 0.0) {
            this.xrad = v.getBrushSize();
            v.sendMessage(TextColors.GREEN, "X radius  set to " + this.xrad);
        }
        if (this.yrad <= 0.0) {
            this.yrad = v.getBrushSize();
            v.sendMessage(TextColors.GREEN, "Y radius  set to " + this.yrad);
        }
        if (this.zrad <= 0.0) {
            this.zrad = v.getBrushSize();
            v.sendMessage(TextColors.GREEN, "Z radius  set to " + this.zrad);
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.ellipsoid";
    }
}

