/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class ExtrudeBrush
extends Brush {
    public ExtrudeBrush() {
        this.setName("Extrude");
    }

    private void extrude(SnipeData v, Location<World> targetBlock, Direction axis) {
        double brushSize = v.getBrushSize();
        double brushSizeSquared = brushSize * brushSize;
        this.undo = new Undo(GenericMath.floor((double)(Math.PI * (brushSize + 1.0) * (brushSize + 1.0) * (double)v.getVoxelHeight())));
        int size = GenericMath.floor((double)brushSize) + 1;
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                if (!((double)(x * x + z * z) < brushSizeSquared) || !v.getVoxelList().contains(this.get(x, z, axis, targetBlock))) continue;
                for (int y = 0; y < v.getVoxelHeight(); ++y) {
                    this.set(x, z, axis, targetBlock, v.getVoxelIdState(), y);
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    private BlockState get(int x, int y, Direction axis, Location<World> target) {
        if (axis == Direction.UP || axis == Direction.DOWN) {
            return this.world.getBlock(x + target.getBlockX(), target.getBlockY(), y + target.getBlockZ());
        }
        if (axis == Direction.EAST || axis == Direction.WEST) {
            return this.world.getBlock(target.getBlockX(), x + target.getBlockY(), y + target.getBlockZ());
        }
        return this.world.getBlock(x + target.getBlockX(), y + target.getBlockY(), target.getBlockZ());
    }

    private void set(int x, int y, Direction axis, Location<World> target, BlockState state, int offs) {
        if (axis == Direction.UP || axis == Direction.DOWN) {
            if (axis == Direction.DOWN) {
                offs *= -1;
            }
            this.setBlockState(x + target.getBlockX(), target.getBlockY() + offs, y + target.getBlockZ(), state);
        } else if (axis == Direction.EAST || axis == Direction.WEST) {
            if (axis == Direction.EAST) {
                offs *= -1;
            }
            this.setBlockState(target.getBlockX() + offs, x + target.getBlockY(), y + target.getBlockZ(), state);
        } else {
            if (axis == Direction.NORTH) {
                offs *= -1;
            }
            this.setBlockState(x + target.getBlockX(), y + target.getBlockY(), target.getBlockZ() + offs, state);
        }
    }

    private void pre(SnipeData v, Location<World> target, boolean towards) {
        if (this.lastBlock.getBlockY() != this.targetBlock.getBlockY()) {
            this.extrude(v, target, this.lastBlock.getBlockY() > this.targetBlock.getBlockY() ^ towards ? Direction.DOWN : Direction.UP);
        } else if (this.lastBlock.getBlockX() != this.targetBlock.getBlockX()) {
            this.extrude(v, target, this.lastBlock.getBlockX() > this.targetBlock.getBlockX() ^ towards ? Direction.EAST : Direction.WEST);
        } else if (this.lastBlock.getBlockZ() != this.targetBlock.getBlockZ()) {
            this.extrude(v, target, this.lastBlock.getBlockZ() > this.targetBlock.getBlockZ() ^ towards ? Direction.NORTH : Direction.SOUTH);
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.pre(v, (Location<World>)this.targetBlock, false);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.pre(v, (Location<World>)this.targetBlock, true);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.height();
        vm.voxelList();
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.extrude";
    }
}

