/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import com.thevoxelbox.voxelsniper.util.BlockHelper;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class FillDownBrush
extends PerformBrush {
    private boolean fillLiquid = true;
    private boolean fromExisting = false;

    public FillDownBrush() {
        this.setName("Fill Down");
    }

    private void fillDown(SnipeData v, Location<World> targetBlock) {
        double brushSize = v.getBrushSize();
        double brushSizeSquared = brushSize * brushSize;
        int tx = targetBlock.getBlockX();
        int tz = targetBlock.getBlockZ();
        int minx = GenericMath.floor((double)((double)targetBlock.getBlockX() - brushSize));
        int maxx = GenericMath.floor((double)((double)targetBlock.getBlockX() + brushSize)) + 1;
        int minz = GenericMath.floor((double)((double)targetBlock.getBlockZ() - brushSize));
        int maxz = GenericMath.floor((double)((double)targetBlock.getBlockZ() + brushSize)) + 1;
        this.undo = new Undo(GenericMath.floor((double)(Math.PI * 4 * (brushSize + 1.0) * (brushSize + 1.0) * (brushSize + 1.0) / 3.0)));
        for (int x = minx; x <= maxx; ++x) {
            double xs = (tx - x) * (tx - x);
            block1: for (int z = minz; z <= maxz; ++z) {
                double zs = (tz - z) * (tz - z);
                if (!(xs + zs < brushSizeSquared)) continue;
                int y = targetBlock.getBlockY();
                if (this.fromExisting) {
                    for (int y0 = -v.getVoxelHeight(); y0 < v.getVoxelHeight(); ++y0) {
                        if (this.world.getBlock(x, y + y0, z) == v.getReplaceIdState()) continue;
                        y += y0 - 1;
                        break;
                    }
                }
                while (y >= 0) {
                    if (this.replace != PerformBrush.PerformerType.NONE) {
                        if (!this.perform(v, x, y, z)) {
                            continue block1;
                        }
                    } else {
                        BlockState current = this.world.getBlock(x, y, z);
                        if (current.getType() == BlockTypes.AIR) {
                            this.perform(v, x, y, z);
                        } else if (this.fillLiquid && BlockHelper.isLiquid(current)) {
                            this.perform(v, x, y, z);
                        }
                    }
                    --y;
                }
            }
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.fillDown(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.fillDown(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 0; i < par.length; ++i) {
            if (par[i].equalsIgnoreCase("info")) {
                v.sendMessage(TextColors.GOLD, "Fill Down Parameters:");
                v.sendMessage(TextColors.AQUA, "/b fd some -- Fills only into air.");
                v.sendMessage(TextColors.AQUA, "/b fd all -- Fills into liquids as well. (Default)");
                v.sendMessage(TextColors.AQUA, "/b fd -e -- Fills only own from existing blocks. (Toggle)");
                return;
            }
            if (par[i].equalsIgnoreCase("all")) {
                this.fillLiquid = true;
                v.sendMessage(TextColors.AQUA, "Now filling liquids as well as air.");
                continue;
            }
            if (par[i].equalsIgnoreCase("some")) {
                this.fillLiquid = false;
                v.sendMessage(TextColors.AQUA, "Now only filling air.");
                continue;
            }
            if (par[i].equalsIgnoreCase("-e")) {
                this.fromExisting = !this.fromExisting;
                v.sendMessage(TextColors.AQUA, "Now filling down from " + (this.fromExisting ? "existing" : "all") + " blocks.");
                continue;
            }
            v.sendMessage(TextColors.RED, "Invalid brush parameters! use the info parameter to display parameter info.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.filldown";
    }
}

