/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import java.util.UUID;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.world.extent.Extent;

public class LineBrush
extends PerformBrush {
    private boolean continuous = false;
    private Vector3d origin;
    private UUID worldUid;

    public LineBrush() {
        this.setName("Line");
    }

    private void linePowder(SnipeData v) {
        Vector3d target = this.targetBlock.getBlockPosition().toDouble().add(0.5, 0.5, 0.5);
        Vector3d dir = target.sub(this.origin);
        double dist = target.distance(this.origin);
        this.undo = new Undo((int)(dist + 2.0));
        BlockRay ray = BlockRay.from((Extent)this.world, (Vector3d)this.origin).distanceLimit(dist).direction(dir).build();
        this.perform(v, this.origin.getFloorX(), this.origin.getFloorY(), this.origin.getFloorZ());
        while (ray.hasNext()) {
            Vector3i pos = ray.next().getBlockPosition();
            this.perform(v, pos.getX(), pos.getY(), pos.getZ());
        }
        if (this.continuous) {
            this.origin = target;
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.worldUid = this.world.getUniqueId();
        this.origin = this.targetBlock.getBlockPosition().toDouble().add(0.5, 0.5, 0.5);
        v.sendMessage(TextColors.DARK_PURPLE, "First point selected.");
    }

    @Override
    protected final void powder(SnipeData v) {
        if (this.origin == null || !this.world.getUniqueId().equals(this.worldUid)) {
            v.sendMessage(TextColors.RED, "Warning: You did not select a first coordinate with the arrow");
        } else {
            this.linePowder(v);
        }
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        if (par.length == 0 || par[0].equalsIgnoreCase("info")) {
            v.sendMessage(TextColors.GOLD, "Line Brush instructions: Right click first point with the arrow. Right click with powder to draw a line to set the second point.");
            v.sendMessage(TextColors.GOLD + "Line brush Parameters:");
            v.sendMessage(TextColors.AQUA + "/b line continue -- Each line will be drawn from the endpoint of the last line.");
            return;
        }
        this.continuous = false;
        if (par[0].equalsIgnoreCase("continue")) {
            this.continuous = true;
            v.sendMessage(TextColors.AQUA, "Line brush Continuous mode enabled.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.line";
    }
}

