/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class OverlayBrush
extends PerformBrush {
    private static final int DEFAULT_DEPTH = 3;
    private int depth = 3;

    public OverlayBrush() {
        this.setName("Overlay (Topsoil Filling)");
    }

    private void overlay(SnipeData v, Location<World> targetBlock, int offset) {
        double brushSize = v.getBrushSize();
        double brushSizeSquared = brushSize * brushSize;
        int tx = this.targetBlock.getBlockX();
        int tz = this.targetBlock.getBlockZ();
        int minx = GenericMath.floor((double)((double)targetBlock.getBlockX() - brushSize));
        int maxx = GenericMath.floor((double)((double)targetBlock.getBlockX() + brushSize)) + 1;
        int minz = GenericMath.floor((double)((double)targetBlock.getBlockZ() - brushSize));
        int maxz = GenericMath.floor((double)((double)targetBlock.getBlockZ() + brushSize)) + 1;
        this.undo = new Undo(GenericMath.floor((double)(Math.PI * (brushSize + 1.0) * (brushSize + 1.0))));
        for (int x = minx; x <= maxx; ++x) {
            double xs = (tx - x) * (tx - x);
            for (int z = minz; z <= maxz; ++z) {
                int y;
                double zs = (tz - z) * (tz - z);
                if (!(xs + zs < brushSizeSquared)) continue;
                for (y = Math.min(targetBlock.getBlockY() + offset, WORLD_HEIGHT); y >= 0 && this.world.getBlockType(x, y, z) == BlockTypes.AIR; --y) {
                }
                if (y == targetBlock.getBlockY() && y < WORLD_HEIGHT && this.world.getBlockType(x, y + 1, z) != BlockTypes.AIR) continue;
                for (int y0 = Math.min(y + offset, WORLD_HEIGHT); y0 > y - this.depth && (y0 > y || this.world.getBlockType(x, y0, z) != BlockTypes.AIR); --y0) {
                    this.perform(v, x, y0, z);
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.overlay(v, (Location<World>)this.targetBlock, 0);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.overlay(v, (Location<World>)this.lastBlock, 1);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.custom(TextColors.AQUA, "Depth set to " + this.depth);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        if (par.length > 0) {
            if (par[0].equalsIgnoreCase("info")) {
                v.sendMessage(TextColors.GOLD, "Overlay brush parameters:");
                v.sendMessage(TextColors.AQUA, "d[number] (ex:  d3) How many blocks deep you want to replace from the surface.");
                return;
            }
            if (par[0].startsWith("d")) {
                try {
                    this.depth = Integer.parseInt(par[0].replace("d", ""));
                    if (this.depth < 1) {
                        this.depth = 1;
                    }
                    v.sendMessage(TextColors.AQUA, "Depth set to " + this.depth);
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Depth isn't a number.");
                }
            } else {
                v.sendMessage(TextColors.RED, "Invalid brush parameters! use the info parameter to display parameter info.");
            }
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.overlay";
    }
}

