/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class RingBrush
extends PerformBrush {
    private double innerSize = 0.0;

    public RingBrush() {
        this.setName("Ring");
    }

    private void ring(SnipeData v, Location<World> targetBlock) {
        double brushSize = v.getBrushSize();
        double brushSizeSquared = brushSize * brushSize;
        double innerRadiusSquared = this.innerSize * this.innerSize;
        int tx = targetBlock.getBlockX();
        int tz = targetBlock.getBlockZ();
        int minx = GenericMath.floor((double)((double)targetBlock.getBlockX() - brushSize));
        int maxx = GenericMath.floor((double)((double)targetBlock.getBlockX() + brushSize)) + 1;
        int minz = GenericMath.floor((double)((double)targetBlock.getBlockZ() - brushSize));
        int maxz = GenericMath.floor((double)((double)targetBlock.getBlockZ() + brushSize)) + 1;
        this.undo = new Undo(GenericMath.floor((double)(Math.PI * (brushSize + 1.0) * (brushSize + 1.0))));
        for (int x = minx; x <= maxx; ++x) {
            double xs = (tx - x) * (tx - x);
            for (int z = minz; z <= maxz; ++z) {
                double zs = (tz - z) * (tz - z);
                if (!(xs + zs < brushSizeSquared) || !(xs + zs >= innerRadiusSquared)) continue;
                this.perform(v, x, targetBlock.getBlockY(), z);
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.ring(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.ring(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.custom(TextColors.AQUA, "The inner radius is ", TextColors.RED, this.innerSize);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 0; i < par.length; ++i) {
            if (par[i].equalsIgnoreCase("info")) {
                v.sendMessage(TextColors.GOLD, "Ring Brush Parameters:");
                v.sendMessage(TextColors.AQUA, "/b ri ir2.5 -- will set the inner radius to 2.5 units");
                return;
            }
            if (par[i].startsWith("ir")) {
                try {
                    double d;
                    this.innerSize = d = Double.parseDouble(par[i].replace("ir", ""));
                    v.sendMessage(TextColors.AQUA, "The inner radius has been set to ", TextColors.RED, this.innerSize);
                }
                catch (Exception exception) {
                    v.sendMessage(TextColors.RED, "Inner radius must be a number.");
                }
                continue;
            }
            v.sendMessage(TextColors.RED, "Invalid brush parameters! use the info parameter to display parameter info.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.ring";
    }
}

