/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.vector.Vector3i;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import java.util.UUID;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SetBrush
extends PerformBrush {
    private static final int SELECTION_SIZE_MAX = 5000000;
    private Vector3i block = null;
    private UUID worldUid;

    public SetBrush() {
        this.setName("Set");
    }

    private void set(SnipeData v, Location<World> bl) {
        if (this.block == null || !((World)bl.getExtent()).getUniqueId().equals(this.worldUid)) {
            this.block = bl.getBlockPosition();
            this.worldUid = ((World)bl.getExtent()).getUniqueId();
            v.sendMessage(TextColors.GRAY, "Point one");
            return;
        }
        int lowX = this.block.getX() <= bl.getBlockX() ? this.block.getX() : bl.getBlockX();
        int lowY = this.block.getY() <= bl.getBlockY() ? this.block.getY() : bl.getBlockY();
        int lowZ = this.block.getZ() <= bl.getBlockZ() ? this.block.getZ() : bl.getBlockZ();
        int highX = this.block.getX() >= bl.getBlockX() ? this.block.getX() : bl.getBlockX();
        int highY = this.block.getY() >= bl.getBlockY() ? this.block.getY() : bl.getBlockY();
        int highZ = this.block.getZ() >= bl.getBlockZ() ? this.block.getZ() : bl.getBlockZ();
        int size = Math.abs(highX - lowX) * Math.abs(highZ - lowZ) * Math.abs(highY - lowY);
        if (size > 5000000) {
            v.sendMessage(TextColors.RED + "Selection size above hardcoded limit, please use a smaller selection.");
            return;
        }
        this.undo = new Undo(size);
        for (int y = lowY; y <= highY; ++y) {
            for (int x = lowX; x <= highX; ++x) {
                for (int z = lowZ; z <= highZ; ++z) {
                    this.perform(v, x, y, z);
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
        this.block = null;
        this.worldUid = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.set(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.set(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        super.parameters(par, v);
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.set";
    }
}

