/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.vector.Vector3i;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import com.thevoxelbox.voxelsniper.util.BlockBuffer;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class ShellBallBrush
extends Brush {
    public ShellBallBrush() {
        this.setName("Shell Ball");
    }

    private void bShell(SnipeData v, Location<World> targetBlock) {
        int z0;
        int z;
        int y0;
        int y;
        int x0;
        int x;
        int brushSize = GenericMath.floor((double)v.getBrushSize()) + 1;
        double brushSizeSquared = brushSize * brushSize;
        int tx = targetBlock.getBlockX();
        int ty = targetBlock.getBlockY();
        int tz = targetBlock.getBlockZ();
        BlockBuffer buffer = new BlockBuffer(new Vector3i(-brushSize, -brushSize, -brushSize), new Vector3i(brushSize, brushSize, brushSize));
        for (x = -brushSize; x <= brushSize; ++x) {
            x0 = tx + x;
            for (y = -brushSize; y <= brushSize; ++y) {
                y0 = ty + y;
                for (z = -brushSize; z <= brushSize; ++z) {
                    z0 = tz + z;
                    if ((double)(x * x + y * y + z * z) >= brushSizeSquared || y <= 0 || y >= WORLD_HEIGHT || this.world.getBlock(x0, y0, z0) != v.getReplaceIdState()) continue;
                    int blocks = 0;
                    if (this.world.getBlock(x0 + 1, y0, z0) == v.getReplaceIdState()) {
                        ++blocks;
                    }
                    if (this.world.getBlock(x0 - 1, y0, z0) == v.getReplaceIdState()) {
                        ++blocks;
                    }
                    if (this.world.getBlock(x0, y0 + 1, z0) == v.getReplaceIdState()) {
                        ++blocks;
                    }
                    if (this.world.getBlock(x0, y0 - 1, z0) == v.getReplaceIdState()) {
                        ++blocks;
                    }
                    if (this.world.getBlock(x0, y0, z0 + 1) == v.getReplaceIdState()) {
                        ++blocks;
                    }
                    if (this.world.getBlock(x0, y0, z0 - 1) == v.getReplaceIdState()) {
                        ++blocks;
                    }
                    if (blocks != 6) continue;
                    buffer.set(x, y, z, v.getVoxelIdState());
                }
            }
        }
        this.undo = new Undo(buffer.getBlockCount());
        for (x = -brushSize; x <= brushSize; ++x) {
            x0 = x + tx;
            for (y = -brushSize; y <= brushSize; ++y) {
                y0 = y + ty;
                for (z = -brushSize; z <= brushSize; ++z) {
                    z0 = z + tz;
                    if (!buffer.contains(x, y, z)) continue;
                    this.setBlockState(x0, y0, z0, buffer.get(x, y, z));
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.bShell(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.bShell(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.voxel();
        vm.replace();
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.shellball";
    }
}

