/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.vector.Vector3i;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import com.thevoxelbox.voxelsniper.util.BlockBuffer;
import java.util.UUID;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class ShellSetBrush
extends Brush {
    private Vector3i pos1;
    private UUID worldUid;

    public ShellSetBrush() {
        this.setName("Shell Set");
    }

    private void sShell(SnipeData v, Vector3i pos1, Vector3i pos2) {
        int z;
        int y;
        int x;
        int minx = Math.min(pos1.getX(), pos2.getX());
        int miny = Math.min(pos1.getY(), pos2.getY());
        int minz = Math.min(pos1.getZ(), pos2.getZ());
        int maxx = Math.max(pos1.getX(), pos2.getX());
        int maxy = Math.max(pos1.getY(), pos2.getY());
        int maxz = Math.max(pos1.getZ(), pos2.getZ());
        BlockBuffer buffer = new BlockBuffer(new Vector3i(minx, miny, minz), new Vector3i(maxx, maxy, maxz));
        for (x = minx; x <= maxx; ++x) {
            for (y = miny; y <= maxy; ++y) {
                for (z = minz; z <= maxz; ++z) {
                    if (y <= 0 || y >= WORLD_HEIGHT || this.world.getBlock(x, y, z) != v.getReplaceIdState()) continue;
                    int blocks = 0;
                    if (this.world.getBlock(x + 1, y, z) == v.getReplaceIdState()) {
                        ++blocks;
                    }
                    if (this.world.getBlock(x - 1, y, z) == v.getReplaceIdState()) {
                        ++blocks;
                    }
                    if (this.world.getBlock(x, y + 1, z) == v.getReplaceIdState()) {
                        ++blocks;
                    }
                    if (this.world.getBlock(x, y - 1, z) == v.getReplaceIdState()) {
                        ++blocks;
                    }
                    if (this.world.getBlock(x, y, z + 1) == v.getReplaceIdState()) {
                        ++blocks;
                    }
                    if (this.world.getBlock(x, y, z - 1) == v.getReplaceIdState()) {
                        ++blocks;
                    }
                    if (blocks != 6) continue;
                    buffer.set(x, y, z, v.getVoxelIdState());
                }
            }
        }
        this.undo = new Undo(buffer.getBlockCount());
        for (x = minx; x <= maxx; ++x) {
            for (y = miny; y <= maxy; ++y) {
                for (z = minz; z <= maxz; ++z) {
                    if (!buffer.contains(x, y, z)) continue;
                    this.setBlockState(x, y, z, buffer.get(x, y, z));
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    private void pos(SnipeData v, Location<World> target) {
        if (this.worldUid == null || !((World)target.getExtent()).getUniqueId().equals(this.worldUid)) {
            this.pos1 = target.getBlockPosition();
            v.sendMessage(TextColors.GRAY, "First point set.");
        } else {
            this.sShell(v, target.getBlockPosition(), this.pos1);
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.pos(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.pos(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.voxel();
        vm.replace();
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.shellset";
    }
}

