/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.vector.Vector3d;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import org.spongepowered.api.text.format.TextColors;

public class ThreePointCircleBrush
extends PerformBrush {
    private Vector3d coordsOne;
    private Vector3d coordsTwo;
    private Vector3d coordsThree;
    private Tolerance tolerance = Tolerance.DEFAULT;

    public ThreePointCircleBrush() {
        this.setName("3-Point Circle");
    }

    @Override
    protected final void arrow(SnipeData v) {
        if (this.coordsOne == null) {
            this.coordsOne = this.targetBlock.getPosition().add(0.5, 0.5, 0.5);
            v.sendMessage(TextColors.GRAY, "First Corner set.");
        } else if (this.coordsTwo == null) {
            this.coordsTwo = this.targetBlock.getPosition().add(0.5, 0.5, 0.5);
            v.sendMessage(TextColors.GRAY, "Second Corner set.");
        } else if (this.coordsThree == null) {
            this.coordsThree = this.targetBlock.getPosition().add(0.5, 0.5, 0.5);
            v.sendMessage(TextColors.GRAY, "Third Corner set.");
        } else {
            this.coordsOne = this.targetBlock.getPosition().add(0.5, 0.5, 0.5);
            this.coordsTwo = null;
            this.coordsThree = null;
            v.sendMessage(TextColors.GRAY, "First Corner set.");
        }
    }

    @Override
    protected final void powder(SnipeData v) {
        if (this.coordsOne == null || this.coordsTwo == null || this.coordsThree == null) {
            return;
        }
        v.sendMessage(TextColors.RED, "Unfortunately the three-point circle is currently disabled as it does not work :(");
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        switch (this.tolerance) {
            case ACCURATE: {
                vm.custom(TextColors.GOLD, "Mode: Accurate");
                break;
            }
            case DEFAULT: {
                vm.custom(TextColors.GOLD, "Mode: Default");
                break;
            }
            case SMOOTH: {
                vm.custom(TextColors.GOLD, "Mode: Smooth");
                break;
            }
            default: {
                vm.custom(TextColors.GOLD, "Mode: Unknown");
            }
        }
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        if (par.length > 0 && par[0].equalsIgnoreCase("info")) {
            v.sendMessage(TextColors.YELLOW, "3-Point Circle Brush instructions: Select three corners with the arrow brush, then generate the Circle with the powder brush.");
            String toleranceOptions = "";
            for (Tolerance tolerance : Tolerance.values()) {
                if (!toleranceOptions.isEmpty()) {
                    toleranceOptions = toleranceOptions + "|";
                }
                toleranceOptions = toleranceOptions + tolerance.name().toLowerCase();
            }
            v.sendMessage(TextColors.GOLD, "/b tpc " + toleranceOptions + " -- Toggle the calculations to emphasize accuracy or smoothness");
            return;
        }
        for (int i = 0; i < par.length; ++i) {
            String parameter = par[i].toUpperCase();
            try {
                this.tolerance = Tolerance.valueOf(parameter);
                v.sendMessage(TextColors.AQUA, "Brush set to " + this.tolerance.name().toLowerCase() + " tolerance.");
                return;
            }
            catch (IllegalArgumentException exception) {
                v.getVoxelMessage().brushMessage("No such tolerance.");
                continue;
            }
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.threepointcircle";
    }

    private static enum Tolerance {
        DEFAULT(1000),
        ACCURATE(10),
        SMOOTH(2000);

        private int value;

        private Tolerance(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

