/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import org.spongepowered.api.text.format.TextColors;

public class TriangleBrush
extends PerformBrush {
    private double[] coordsOne = new double[3];
    private double[] coordsTwo = new double[3];
    private double[] coordsThree = new double[3];
    private int cornernumber = 1;
    private double[] currentCoords = new double[3];
    private double[] vectorOne = new double[3];
    private double[] vectorTwo = new double[3];
    private double[] vectorThree = new double[3];
    private double[] normalVector = new double[3];

    public TriangleBrush() {
        this.setName("Triangle");
    }

    private void triangleA(SnipeData v) {
        switch (this.cornernumber) {
            case 1: {
                this.coordsOne[0] = this.targetBlock.getX() + 0.5 * this.targetBlock.getX() / Math.abs(this.targetBlock.getX());
                this.coordsOne[1] = this.targetBlock.getY() + 0.5;
                this.coordsOne[2] = this.targetBlock.getZ() + 0.5 * this.targetBlock.getZ() / Math.abs(this.targetBlock.getZ());
                this.cornernumber = 2;
                v.sendMessage(TextColors.GRAY, "First Corner set.");
                break;
            }
            case 2: {
                this.coordsTwo[0] = this.targetBlock.getX() + 0.5 * this.targetBlock.getX() / Math.abs(this.targetBlock.getX());
                this.coordsTwo[1] = this.targetBlock.getY() + 0.5;
                this.coordsTwo[2] = this.targetBlock.getZ() + 0.5 * this.targetBlock.getZ() / Math.abs(this.targetBlock.getZ());
                this.cornernumber = 3;
                v.sendMessage(TextColors.GRAY, "Second Corner set.");
                break;
            }
            case 3: {
                this.coordsThree[0] = this.targetBlock.getX() + 0.5 * this.targetBlock.getX() / Math.abs(this.targetBlock.getX());
                this.coordsThree[1] = this.targetBlock.getY() + 0.5;
                this.coordsThree[2] = this.targetBlock.getZ() + 0.5 * this.targetBlock.getZ() / Math.abs(this.targetBlock.getZ());
                this.cornernumber = 1;
                v.sendMessage(TextColors.GRAY, "Third Corner set.");
                break;
            }
        }
    }

    private void triangleP(SnipeData v) {
        double lengthOne = 0.0;
        double lengthTwo = 0.0;
        double lengthThree = 0.0;
        double heronBig = 0.0;
        for (int i = 0; i < 3; ++i) {
            this.vectorOne[i] = this.coordsTwo[i] - this.coordsOne[i];
            this.vectorTwo[i] = this.coordsThree[i] - this.coordsOne[i];
            this.vectorThree[i] = this.coordsThree[i] - this.coordsTwo[i];
        }
        this.normalVector[0] = this.vectorOne[1] * this.vectorTwo[2] - this.vectorOne[2] * this.vectorTwo[1];
        this.normalVector[1] = this.vectorOne[2] * this.vectorTwo[0] - this.vectorOne[0] * this.vectorTwo[2];
        this.normalVector[2] = this.vectorOne[0] * this.vectorTwo[1] - this.vectorOne[1] * this.vectorTwo[0];
        lengthOne = Math.pow(Math.pow(this.vectorOne[0], 2.0) + Math.pow(this.vectorOne[1], 2.0) + Math.pow(this.vectorOne[2], 2.0), 0.5);
        lengthTwo = Math.pow(Math.pow(this.vectorTwo[0], 2.0) + Math.pow(this.vectorTwo[1], 2.0) + Math.pow(this.vectorTwo[2], 2.0), 0.5);
        lengthThree = Math.pow(Math.pow(this.vectorThree[0], 2.0) + Math.pow(this.vectorThree[1], 2.0) + Math.pow(this.vectorThree[2], 2.0), 0.5);
        int brushSize = (int)Math.ceil(lengthOne > lengthTwo ? lengthOne : lengthTwo);
        double planeConstant = this.normalVector[0] * this.coordsOne[0] + this.normalVector[1] * this.coordsOne[1] + this.normalVector[2] * this.coordsOne[2];
        heronBig = 0.25 * Math.pow(Math.pow(Math.pow(lengthOne, 2.0) + Math.pow(lengthTwo, 2.0) + Math.pow(lengthThree, 2.0), 2.0) - 2.0 * (Math.pow(lengthOne, 4.0) + Math.pow(lengthTwo, 4.0) + Math.pow(lengthThree, 4.0)), 0.5);
        this.undo = new Undo(16);
        if (lengthOne == 0.0 || lengthTwo == 0.0 || this.coordsOne[0] == 0.0 && this.coordsOne[1] == 0.0 && this.coordsOne[2] == 0.0 || this.coordsTwo[0] == 0.0 && this.coordsTwo[1] == 0.0 && this.coordsTwo[2] == 0.0 || this.coordsThree[0] == 0.0 && this.coordsThree[1] == 0.0 && this.coordsThree[2] == 0.0) {
            v.sendMessage(TextColors.RED + "ERROR: Invalid corners, please try again.");
        } else {
            int x;
            double barycentric;
            double heronThree;
            double heronTwo;
            double heronOne;
            double cLengthThree;
            double cLengthTwo;
            double cLengthOne;
            int z;
            double[] cVectorOne = new double[3];
            double[] cVectorTwo = new double[3];
            double[] cVectorThree = new double[3];
            for (int y = -brushSize; y <= brushSize; ++y) {
                for (z = -brushSize; z <= brushSize; ++z) {
                    this.currentCoords[1] = this.coordsOne[1] + (double)y;
                    this.currentCoords[2] = this.coordsOne[2] + (double)z;
                    this.currentCoords[0] = (planeConstant - this.normalVector[1] * this.currentCoords[1] - this.normalVector[2] * this.currentCoords[2]) / this.normalVector[0];
                    for (int i = 0; i < 3; ++i) {
                        cVectorOne[i] = this.coordsTwo[i] - this.coordsOne[i];
                        cVectorTwo[i] = this.currentCoords[i] - this.coordsOne[i];
                        cVectorThree[i] = this.currentCoords[i] - this.coordsTwo[i];
                    }
                    cLengthOne = Math.pow(Math.pow(cVectorOne[0], 2.0) + Math.pow(cVectorOne[1], 2.0) + Math.pow(cVectorOne[2], 2.0), 0.5);
                    cLengthTwo = Math.pow(Math.pow(cVectorTwo[0], 2.0) + Math.pow(cVectorTwo[1], 2.0) + Math.pow(cVectorTwo[2], 2.0), 0.5);
                    cLengthThree = Math.pow(Math.pow(cVectorThree[0], 2.0) + Math.pow(cVectorThree[1], 2.0) + Math.pow(cVectorThree[2], 2.0), 0.5);
                    heronOne = 0.25 * Math.pow(Math.pow(Math.pow(cLengthOne, 2.0) + Math.pow(cLengthTwo, 2.0) + Math.pow(cLengthThree, 2.0), 2.0) - 2.0 * (Math.pow(cLengthOne, 4.0) + Math.pow(cLengthTwo, 4.0) + Math.pow(cLengthThree, 4.0)), 0.5);
                    for (int i = 0; i < 3; ++i) {
                        cVectorOne[i] = this.coordsTwo[i] - this.coordsThree[i];
                        cVectorTwo[i] = this.currentCoords[i] - this.coordsThree[i];
                        cVectorThree[i] = this.currentCoords[i] - this.coordsTwo[i];
                    }
                    cLengthOne = Math.pow(Math.pow(cVectorOne[0], 2.0) + Math.pow(cVectorOne[1], 2.0) + Math.pow(cVectorOne[2], 2.0), 0.5);
                    cLengthTwo = Math.pow(Math.pow(cVectorTwo[0], 2.0) + Math.pow(cVectorTwo[1], 2.0) + Math.pow(cVectorTwo[2], 2.0), 0.5);
                    cLengthThree = Math.pow(Math.pow(cVectorThree[0], 2.0) + Math.pow(cVectorThree[1], 2.0) + Math.pow(cVectorThree[2], 2.0), 0.5);
                    heronTwo = 0.25 * Math.pow(Math.pow(Math.pow(cLengthOne, 2.0) + Math.pow(cLengthTwo, 2.0) + Math.pow(cLengthThree, 2.0), 2.0) - 2.0 * (Math.pow(cLengthOne, 4.0) + Math.pow(cLengthTwo, 4.0) + Math.pow(cLengthThree, 4.0)), 0.5);
                    for (int i = 0; i < 3; ++i) {
                        cVectorOne[i] = this.coordsOne[i] - this.coordsThree[i];
                        cVectorTwo[i] = this.currentCoords[i] - this.coordsThree[i];
                        cVectorThree[i] = this.currentCoords[i] - this.coordsOne[i];
                    }
                    cLengthOne = Math.pow(Math.pow(cVectorOne[0], 2.0) + Math.pow(cVectorOne[1], 2.0) + Math.pow(cVectorOne[2], 2.0), 0.5);
                    cLengthTwo = Math.pow(Math.pow(cVectorTwo[0], 2.0) + Math.pow(cVectorTwo[1], 2.0) + Math.pow(cVectorTwo[2], 2.0), 0.5);
                    cLengthThree = Math.pow(Math.pow(cVectorThree[0], 2.0) + Math.pow(cVectorThree[1], 2.0) + Math.pow(cVectorThree[2], 2.0), 0.5);
                    heronThree = 0.25 * Math.pow(Math.pow(Math.pow(cLengthOne, 2.0) + Math.pow(cLengthTwo, 2.0) + Math.pow(cLengthThree, 2.0), 2.0) - 2.0 * (Math.pow(cLengthOne, 4.0) + Math.pow(cLengthTwo, 4.0) + Math.pow(cLengthThree, 4.0)), 0.5);
                    barycentric = (heronOne + heronTwo + heronThree) / heronBig;
                    if (!(barycentric <= 1.1)) continue;
                    this.perform(v, (int)this.currentCoords[0], (int)this.currentCoords[1], (int)this.currentCoords[2]);
                }
            }
            for (x = -brushSize; x <= brushSize; ++x) {
                for (z = -brushSize; z <= brushSize; ++z) {
                    this.currentCoords[0] = this.coordsOne[0] + (double)x;
                    this.currentCoords[2] = this.coordsOne[2] + (double)z;
                    this.currentCoords[1] = (planeConstant - this.normalVector[0] * this.currentCoords[0] - this.normalVector[2] * this.currentCoords[2]) / this.normalVector[1];
                    for (int i = 0; i < 3; ++i) {
                        cVectorOne[i] = this.coordsTwo[i] - this.coordsOne[i];
                        cVectorTwo[i] = this.currentCoords[i] - this.coordsOne[i];
                        cVectorThree[i] = this.currentCoords[i] - this.coordsTwo[i];
                    }
                    cLengthOne = Math.pow(Math.pow(cVectorOne[0], 2.0) + Math.pow(cVectorOne[1], 2.0) + Math.pow(cVectorOne[2], 2.0), 0.5);
                    cLengthTwo = Math.pow(Math.pow(cVectorTwo[0], 2.0) + Math.pow(cVectorTwo[1], 2.0) + Math.pow(cVectorTwo[2], 2.0), 0.5);
                    cLengthThree = Math.pow(Math.pow(cVectorThree[0], 2.0) + Math.pow(cVectorThree[1], 2.0) + Math.pow(cVectorThree[2], 2.0), 0.5);
                    heronOne = 0.25 * Math.pow(Math.pow(Math.pow(cLengthOne, 2.0) + Math.pow(cLengthTwo, 2.0) + Math.pow(cLengthThree, 2.0), 2.0) - 2.0 * (Math.pow(cLengthOne, 4.0) + Math.pow(cLengthTwo, 4.0) + Math.pow(cLengthThree, 4.0)), 0.5);
                    for (int i = 0; i < 3; ++i) {
                        cVectorOne[i] = this.coordsTwo[i] - this.coordsThree[i];
                        cVectorTwo[i] = this.currentCoords[i] - this.coordsThree[i];
                        cVectorThree[i] = this.currentCoords[i] - this.coordsTwo[i];
                    }
                    cLengthOne = Math.pow(Math.pow(cVectorOne[0], 2.0) + Math.pow(cVectorOne[1], 2.0) + Math.pow(cVectorOne[2], 2.0), 0.5);
                    cLengthTwo = Math.pow(Math.pow(cVectorTwo[0], 2.0) + Math.pow(cVectorTwo[1], 2.0) + Math.pow(cVectorTwo[2], 2.0), 0.5);
                    cLengthThree = Math.pow(Math.pow(cVectorThree[0], 2.0) + Math.pow(cVectorThree[1], 2.0) + Math.pow(cVectorThree[2], 2.0), 0.5);
                    heronTwo = 0.25 * Math.pow(Math.pow(Math.pow(cLengthOne, 2.0) + Math.pow(cLengthTwo, 2.0) + Math.pow(cLengthThree, 2.0), 2.0) - 2.0 * (Math.pow(cLengthOne, 4.0) + Math.pow(cLengthTwo, 4.0) + Math.pow(cLengthThree, 4.0)), 0.5);
                    for (int i = 0; i < 3; ++i) {
                        cVectorOne[i] = this.coordsOne[i] - this.coordsThree[i];
                        cVectorTwo[i] = this.currentCoords[i] - this.coordsThree[i];
                        cVectorThree[i] = this.currentCoords[i] - this.coordsOne[i];
                    }
                    cLengthOne = Math.pow(Math.pow(cVectorOne[0], 2.0) + Math.pow(cVectorOne[1], 2.0) + Math.pow(cVectorOne[2], 2.0), 0.5);
                    cLengthTwo = Math.pow(Math.pow(cVectorTwo[0], 2.0) + Math.pow(cVectorTwo[1], 2.0) + Math.pow(cVectorTwo[2], 2.0), 0.5);
                    cLengthThree = Math.pow(Math.pow(cVectorThree[0], 2.0) + Math.pow(cVectorThree[1], 2.0) + Math.pow(cVectorThree[2], 2.0), 0.5);
                    heronThree = 0.25 * Math.pow(Math.pow(Math.pow(cLengthOne, 2.0) + Math.pow(cLengthTwo, 2.0) + Math.pow(cLengthThree, 2.0), 2.0) - 2.0 * (Math.pow(cLengthOne, 4.0) + Math.pow(cLengthTwo, 4.0) + Math.pow(cLengthThree, 4.0)), 0.5);
                    barycentric = (heronOne + heronTwo + heronThree) / heronBig;
                    if (!(barycentric <= 1.1)) continue;
                    this.perform(v, (int)this.currentCoords[0], (int)this.currentCoords[1], (int)this.currentCoords[2]);
                }
            }
            for (x = -brushSize; x <= brushSize; ++x) {
                for (int y = -brushSize; y <= brushSize; ++y) {
                    this.currentCoords[0] = this.coordsOne[0] + (double)x;
                    this.currentCoords[1] = this.coordsOne[1] + (double)y;
                    this.currentCoords[2] = (planeConstant - this.normalVector[0] * this.currentCoords[0] - this.normalVector[1] * this.currentCoords[1]) / this.normalVector[2];
                    for (int i = 0; i < 3; ++i) {
                        cVectorOne[i] = this.coordsTwo[i] - this.coordsOne[i];
                        cVectorTwo[i] = this.currentCoords[i] - this.coordsOne[i];
                        cVectorThree[i] = this.currentCoords[i] - this.coordsTwo[i];
                    }
                    cLengthOne = Math.pow(Math.pow(cVectorOne[0], 2.0) + Math.pow(cVectorOne[1], 2.0) + Math.pow(cVectorOne[2], 2.0), 0.5);
                    cLengthTwo = Math.pow(Math.pow(cVectorTwo[0], 2.0) + Math.pow(cVectorTwo[1], 2.0) + Math.pow(cVectorTwo[2], 2.0), 0.5);
                    cLengthThree = Math.pow(Math.pow(cVectorThree[0], 2.0) + Math.pow(cVectorThree[1], 2.0) + Math.pow(cVectorThree[2], 2.0), 0.5);
                    heronOne = 0.25 * Math.pow(Math.pow(Math.pow(cLengthOne, 2.0) + Math.pow(cLengthTwo, 2.0) + Math.pow(cLengthThree, 2.0), 2.0) - 2.0 * (Math.pow(cLengthOne, 4.0) + Math.pow(cLengthTwo, 4.0) + Math.pow(cLengthThree, 4.0)), 0.5);
                    for (int i = 0; i < 3; ++i) {
                        cVectorOne[i] = this.coordsTwo[i] - this.coordsThree[i];
                        cVectorTwo[i] = this.currentCoords[i] - this.coordsThree[i];
                        cVectorThree[i] = this.currentCoords[i] - this.coordsTwo[i];
                    }
                    cLengthOne = Math.pow(Math.pow(cVectorOne[0], 2.0) + Math.pow(cVectorOne[1], 2.0) + Math.pow(cVectorOne[2], 2.0), 0.5);
                    cLengthTwo = Math.pow(Math.pow(cVectorTwo[0], 2.0) + Math.pow(cVectorTwo[1], 2.0) + Math.pow(cVectorTwo[2], 2.0), 0.5);
                    cLengthThree = Math.pow(Math.pow(cVectorThree[0], 2.0) + Math.pow(cVectorThree[1], 2.0) + Math.pow(cVectorThree[2], 2.0), 0.5);
                    heronTwo = 0.25 * Math.pow(Math.pow(Math.pow(cLengthOne, 2.0) + Math.pow(cLengthTwo, 2.0) + Math.pow(cLengthThree, 2.0), 2.0) - 2.0 * (Math.pow(cLengthOne, 4.0) + Math.pow(cLengthTwo, 4.0) + Math.pow(cLengthThree, 4.0)), 0.5);
                    for (int i = 0; i < 3; ++i) {
                        cVectorOne[i] = this.coordsOne[i] - this.coordsThree[i];
                        cVectorTwo[i] = this.currentCoords[i] - this.coordsThree[i];
                        cVectorThree[i] = this.currentCoords[i] - this.coordsOne[i];
                    }
                    cLengthOne = Math.pow(Math.pow(cVectorOne[0], 2.0) + Math.pow(cVectorOne[1], 2.0) + Math.pow(cVectorOne[2], 2.0), 0.5);
                    cLengthTwo = Math.pow(Math.pow(cVectorTwo[0], 2.0) + Math.pow(cVectorTwo[1], 2.0) + Math.pow(cVectorTwo[2], 2.0), 0.5);
                    cLengthThree = Math.pow(Math.pow(cVectorThree[0], 2.0) + Math.pow(cVectorThree[1], 2.0) + Math.pow(cVectorThree[2], 2.0), 0.5);
                    heronThree = 0.25 * Math.pow(Math.pow(Math.pow(cLengthOne, 2.0) + Math.pow(cLengthTwo, 2.0) + Math.pow(cLengthThree, 2.0), 2.0) - 2.0 * (Math.pow(cLengthOne, 4.0) + Math.pow(cLengthTwo, 4.0) + Math.pow(cLengthThree, 4.0)), 0.5);
                    barycentric = (heronOne + heronTwo + heronThree) / heronBig;
                    if (!(barycentric <= 1.1)) continue;
                    this.perform(v, (int)this.currentCoords[0], (int)this.currentCoords[1], (int)this.currentCoords[2]);
                }
            }
            v.owner().storeUndo(this.undo);
            this.undo = null;
        }
        this.coordsOne[0] = 0.0;
        this.coordsOne[1] = 0.0;
        this.coordsOne[2] = 0.0;
        this.coordsTwo[0] = 0.0;
        this.coordsTwo[1] = 0.0;
        this.coordsTwo[2] = 0.0;
        this.coordsThree[0] = 0.0;
        this.coordsThree[1] = 0.0;
        this.coordsThree[2] = 0.0;
        this.cornernumber = 1;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.triangleA(v);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.triangleP(v);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        if (par[1].equalsIgnoreCase("info")) {
            v.sendMessage(TextColors.GOLD, "Triangle Brush instructions: Select three corners with the arrow brush, then generate the triangle with the powder brush.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.triangle";
    }
}

